/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignField;
import net.sf.dynamicreports.design.definition.DRIDesignGroup;
import net.sf.dynamicreports.design.definition.DRIDesignSort;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignJasperExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignParameterExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignPropertyExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSimpleExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSystemExpression;
import net.sf.dynamicreports.jasper.base.JasperCustomValues;
import net.sf.dynamicreports.jasper.constant.ValueType;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.report.constant.SystemExpression;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGenericElementParameter;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public abstract class AbstractExpressionTransform {
    private static final String VALUE = "$P'{'{0}'}'.getValue(\"{1}\")";
    private static final String FIELD_VALUE = "$F'{'{0}'}'";
    private static final String VARIABLE_VALUE = "$V'{'{0}'}'";
    private static final String PARAMETER_VALUE = "$P'{'{0}'}'";
    private static final String COMPLEX_VALUE = "$P'{'{0}'}'.getValue(\"{1}\", new Object[]'{'{2}'}')";
    private Map<String, JRDesignExpression> expressions = new HashMap<String, JRDesignExpression>();

    public void transform() {
        for (DRIDesignField dRIDesignField : this.getFields()) {
            this.addField(dRIDesignField);
        }
        for (DRIDesignSystemExpression dRIDesignSystemExpression : this.getSystemExpressions()) {
            this.addSystemExpression(dRIDesignSystemExpression);
        }
        for (DRIDesignJasperExpression dRIDesignJasperExpression : this.getJasperExpressions()) {
            this.addJasperExpression(dRIDesignJasperExpression);
        }
        for (DRIDesignSimpleExpression dRIDesignSimpleExpression : this.getSimpleExpressions()) {
            this.addSimpleExpression(dRIDesignSimpleExpression);
        }
        for (DRIDesignComplexExpression dRIDesignComplexExpression : this.getComplexExpressions()) {
            this.addComplexExpression(dRIDesignComplexExpression);
        }
        for (DRIDesignVariable dRIDesignVariable : this.getVariables()) {
            this.addVariable(dRIDesignVariable);
        }
        for (DRIDesignSort dRIDesignSort : this.getSorts()) {
            this.addSort(dRIDesignSort);
        }
    }

    private void addSystemExpression(DRIDesignSystemExpression systemExpression) {
        if (systemExpression == null) {
            return;
        }
        this.getCustomValues().addValueType(systemExpression.getName(), ValueType.SYSTEM_EXPRESSION);
        this.addExpression(systemExpression);
    }

    private void addJasperExpression(DRIDesignJasperExpression jasperExpression) {
        if (jasperExpression == null) {
            return;
        }
        this.addExpression(jasperExpression);
    }

    protected void addSimpleExpression(DRIDesignSimpleExpression simpleExpression) {
        if (simpleExpression == null) {
            return;
        }
        this.getCustomValues().addSimpleExpression(simpleExpression);
        this.addExpression(simpleExpression);
    }

    private void addField(DRIDesignField field) {
        try {
            if (!field.isExternal()) {
                this.addField(this.field(field));
            }
            this.getCustomValues().addValueType(field.getName(), ValueType.FIELD);
            this.addExpression(field);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for field \"" + field.getName() + "\"", e);
        }
    }

    private void addVariable(DRIDesignVariable variable) {
        try {
            this.addVariable(this.variable(variable));
            this.getCustomValues().addValueType(variable.getName(), ValueType.VARIABLE);
            this.addExpression(variable);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for variable \"" + variable.getName() + "\"", e);
        }
    }

    protected void addComplexExpression(DRIDesignComplexExpression complexExpression) {
        if (complexExpression == null) {
            return;
        }
        this.getCustomValues().addComplexExpression(complexExpression);
        this.addExpression(complexExpression);
    }

    private void addExpression(DRIDesignExpression expression) {
        if (this.expressions.containsKey(expression.getName())) {
            throw new JasperDesignException("Duplicate declaration of expression \"" + expression.getName() + "\"");
        }
        this.expressions.put(expression.getName(), this.expression(expression));
    }

    private void addSort(DRIDesignSort sort) {
        try {
            this.addSort(this.sort(sort));
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for sort \"" + sort.getExpression().getName() + "\"", e);
        }
    }

    private JRDesignField field(DRIDesignField field) {
        JRDesignField jrField = new JRDesignField();
        jrField.setName(field.getName());
        jrField.setValueClass(field.getValueClass());
        jrField.setDescription(field.getDescription());
        return jrField;
    }

    private JRDesignVariable variable(DRIDesignVariable variable) {
        JRDesignExpression expression = this.getExpression(variable.getValueExpression());
        JRDesignExpression initialValueExpression = this.getExpression(variable.getInitialValueExpression());
        JRDesignVariable jrVariable = new JRDesignVariable();
        jrVariable.setName(variable.getName());
        jrVariable.setExpression((JRExpression)expression);
        jrVariable.setInitialValueExpression((JRExpression)initialValueExpression);
        jrVariable.setValueClass(variable.getValueClass());
        jrVariable.setCalculation(ConstantTransform.calculation(variable.getCalculation()));
        ResetType resetType = variable.getResetType();
        jrVariable.setResetType(ConstantTransform.variableResetType(resetType));
        if (resetType.equals((Object)ResetType.GROUP) && variable.getResetGroup() != null) {
            jrVariable.setResetGroup(this.getGroup(variable.getResetGroup()));
        }
        return jrVariable;
    }

    protected JRGroup getGroup(DRIDesignGroup group) {
        return null;
    }

    private JRDesignExpression expression(DRIDesignExpression simpleExpression) {
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText(this.getExpressionText(simpleExpression));
        return expression;
    }

    private String getExpressionText(DRIDesignExpression expression) {
        if (expression instanceof DRIDesignField) {
            return this.toFieldValue(expression.getName());
        }
        if (expression instanceof DRIDesignVariable) {
            return this.toVariableValue(expression.getName());
        }
        if (expression instanceof DRIDesignComplexExpression) {
            DRIDesignComplexExpression complexExpression = (DRIDesignComplexExpression)expression;
            String values = "";
            for (DRIDesignExpression valueExpression : complexExpression.getExpressions()) {
                values = values + ", " + this.getExpressionText(valueExpression);
            }
            if (values.length() > 0) {
                values = values.substring(2);
            }
            String parameterName = this.getExpressionParameterName(complexExpression.getParameterName());
            return MessageFormat.format(COMPLEX_VALUE, parameterName, expression.getName(), values);
        }
        if (expression instanceof DRIDesignSimpleExpression) {
            String parameterName = this.getExpressionParameterName(((DRIDesignSimpleExpression)expression).getParameterName());
            return MessageFormat.format(VALUE, parameterName, expression.getName());
        }
        if (expression instanceof DRIDesignSystemExpression) {
            String name = ((DRIDesignSystemExpression)expression).getName();
            if (name.equals(SystemExpression.PAGE_NUMBER.name())) {
                return this.toVariableValue("PAGE_NUMBER");
            }
            return this.toVariableValue(name);
        }
        if (expression instanceof DRIDesignJasperExpression) {
            return ((DRIDesignJasperExpression)expression).getExpression();
        }
        throw new JasperDesignException("Expression " + expression.getClass().getName() + " not supported");
    }

    private String getExpressionParameterName(String parameterName) {
        if (parameterName == null) {
            return "CUSTOM_VALUES";
        }
        return parameterName;
    }

    private String toFieldValue(String expression) {
        return MessageFormat.format(FIELD_VALUE, expression);
    }

    private String toVariableValue(String expression) {
        return MessageFormat.format(VARIABLE_VALUE, expression);
    }

    protected String toParameterValue(String expression) {
        return MessageFormat.format(PARAMETER_VALUE, expression);
    }

    public JRDesignExpression getExpression(DRIDesignExpression expression) {
        if (expression == null) {
            return null;
        }
        if (!this.expressions.containsKey(expression.getName())) {
            throw new JasperDesignException("Expression \"" + expression.getName() + "\" is not registered");
        }
        return this.expressions.get(expression.getName());
    }

    private JRDesignSortField sort(DRIDesignSort sort) {
        SortFieldTypeEnum type;
        String name;
        DRIDesignExpression expression = sort.getExpression();
        if (expression instanceof DRIDesignField) {
            name = expression.getName();
            type = SortFieldTypeEnum.FIELD;
        } else if (expression instanceof DRIDesignVariable) {
            name = expression.getName();
            type = SortFieldTypeEnum.VARIABLE;
        } else {
            throw new JasperDesignException("Sort expression \"" + expression.getName() + "\" not supported");
        }
        JRDesignSortField jrSort = new JRDesignSortField();
        jrSort.setName(name);
        jrSort.setOrder(ConstantTransform.orderType(sort.getOrderType()));
        jrSort.setType(type);
        return jrSort;
    }

    protected JRPropertyExpression getPropertyExpression(DRIDesignPropertyExpression propertyExpression) {
        JRDesignPropertyExpression jrPropertyExpression = new JRDesignPropertyExpression();
        jrPropertyExpression.setName(propertyExpression.getName());
        jrPropertyExpression.setValueExpression((JRExpression)this.getExpression(propertyExpression.getValueExpression()));
        return jrPropertyExpression;
    }

    protected JRGenericElementParameter getGenericElementParameterExpression(DRIDesignParameterExpression parameterExpression) {
        JRDesignGenericElementParameter jrParameterExpression = new JRDesignGenericElementParameter();
        jrParameterExpression.setName(parameterExpression.getName());
        jrParameterExpression.setValueExpression((JRExpression)this.getExpression(parameterExpression.getValueExpression()));
        return jrParameterExpression;
    }

    protected abstract JasperCustomValues getCustomValues();

    protected abstract Collection<DRIDesignField> getFields();

    protected abstract Collection<DRIDesignVariable> getVariables();

    protected abstract Collection<DRIDesignSystemExpression> getSystemExpressions();

    protected abstract Collection<DRIDesignJasperExpression> getJasperExpressions();

    protected abstract Collection<DRIDesignSimpleExpression> getSimpleExpressions();

    protected abstract Collection<DRIDesignComplexExpression> getComplexExpressions();

    protected abstract Collection<DRIDesignSort> getSorts();

    protected abstract void addField(JRDesignField var1) throws JRException;

    protected abstract void addVariable(JRDesignVariable var1) throws JRException;

    protected abstract void addSort(JRDesignSortField var1) throws JRException;
}

