/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.grid;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.base.grid.DRColumnGridListCell;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGridComponent;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGridList;
import org.apache.commons.lang3.Validate;

public class DRColumnGridList
implements DRIColumnGridList {
    private static final long serialVersionUID = 10000L;
    private List<DRColumnGridListCell> listCells;
    private ListType type;
    private int gap;

    public DRColumnGridList() {
        this(ListType.HORIZONTAL);
    }

    public DRColumnGridList(ListType type) {
        this.setType(type);
        this.listCells = new ArrayList<DRColumnGridListCell>();
    }

    public List<DRColumnGridListCell> getListCells() {
        return this.listCells;
    }

    public void addComponent(DRIColumnGridComponent component) {
        this.listCells.add(new DRColumnGridListCell(component));
    }

    public void addCell(DRColumnGridListCell cell) {
        Validate.notNull((Object)cell, (String)"cell must not be null", (Object[])new Object[0]);
        this.listCells.add(cell);
    }

    public void addComponent(HorizontalCellComponentAlignment horizontalAlignment, VerticalCellComponentAlignment verticalAlignment, DRIColumnGridComponent component) {
        this.listCells.add(new DRColumnGridListCell(horizontalAlignment, verticalAlignment, component));
    }

    @Override
    public ListType getType() {
        return this.type;
    }

    public void setType(ListType type) {
        Validate.notNull((Object)((Object)type), (String)"type must not be null", (Object[])new Object[0]);
        this.type = type;
    }

    @Override
    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        Validate.notNull((Object)(gap < 0 ? 1 : 0), (String)"gap must be >= 0", (Object[])new Object[0]);
        this.gap = gap;
    }
}

