/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;

public abstract class BaseFrameElement
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(BaseFrameElement.class);
    private FrameWindow enclosedWindow_;
    private boolean contentLoaded_;
    private boolean createdByJavascript_;
    private boolean loadSrcWhenAddedToPage_;

    protected BaseFrameElement(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String src;
        this.init();
        if (null != page && page.isHtmlPage() && ((HtmlPage)page).isParsingHtmlSnippet() && (src = this.getSrcAttribute()) != ATTRIBUTE_NOT_DEFINED && !"about:blank".equals(src)) {
            this.loadSrcWhenAddedToPage_ = true;
        }
    }

    private void init() {
        FrameWindow enclosedWindow = null;
        try {
            HtmlPage htmlPage = this.getHtmlPageOrNull();
            if (null != htmlPage) {
                enclosedWindow = new FrameWindow(this);
                WebClient webClient = htmlPage.getWebClient();
                HtmlPage temporaryPage = (HtmlPage)webClient.getPage(enclosedWindow, WebRequest.newAboutBlankRequest());
                temporaryPage.setReadyState("loading");
            }
        }
        catch (FailingHttpStatusCodeException | IOException exception) {
            // empty catch block
        }
        this.enclosedWindow_ = enclosedWindow;
    }

    public void loadInnerPage() throws FailingHttpStatusCodeException {
        String source = this.getSrcAttribute();
        if (source.isEmpty() || StringUtils.startsWithIgnoreCase((CharSequence)source, (CharSequence)"about:")) {
            source = "about:blank";
        }
        this.loadInnerPageIfPossible(source);
        Page enclosedPage = this.getEnclosedPage();
        if (enclosedPage != null && enclosedPage.isHtmlPage()) {
            final HtmlPage htmlPage = (HtmlPage)enclosedPage;
            AbstractJavaScriptEngine<?> jsEngine = this.getPage().getWebClient().getJavaScriptEngine();
            if (jsEngine.isScriptRunning()) {
                PostponedAction action = new PostponedAction(this.getPage()){

                    @Override
                    public void execute() throws Exception {
                        htmlPage.setReadyState("complete");
                    }
                };
                jsEngine.addPostponedAction(action);
            } else {
                htmlPage.setReadyState("complete");
            }
        }
    }

    boolean isContentLoaded() {
        return this.contentLoaded_;
    }

    void setContentLoaded() {
        this.contentLoaded_ = true;
    }

    private void loadInnerPageIfPossible(String src) throws FailingHttpStatusCodeException {
        block6: {
            this.setContentLoaded();
            if (!src.isEmpty()) {
                URL url;
                try {
                    url = ((HtmlPage)this.getPage()).getFullyQualifiedUrl(src);
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                    return;
                }
                WebRequest request = new WebRequest(url);
                request.setCharset(this.getPage().getCharset());
                request.setAdditionalHeader("Referer", this.getPage().getUrl().toExternalForm());
                if (this.isAlreadyLoadedByAncestor(url, request.getCharset())) {
                    this.notifyIncorrectness("Recursive src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                    return;
                }
                try {
                    this.getPage().getEnclosingWindow().getWebClient().getPage(this.enclosedWindow_, request);
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)("IOException when getting content for " + this.getTagName() + ": url=[" + url + "]"), (Throwable)e);
                }
            }
        }
    }

    private boolean isAlreadyLoadedByAncestor(URL url, Charset charset) {
        WebWindow window = this.getPage().getEnclosingWindow();
        while (window != null) {
            URL encUrl = UrlUtils.encodeUrl(url, window.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_MINIMAL_QUERY_ENCODING), charset);
            if (UrlUtils.sameFile(encUrl, window.getEnclosedPage().getUrl())) {
                return true;
            }
            if (window == window.getParentWindow()) {
                window = null;
                continue;
            }
            window = window.getParentWindow();
        }
        return false;
    }

    public final String getLongDescAttribute() {
        return this.getAttributeDirect("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getFrameBorderAttribute() {
        return this.getAttributeDirect("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttributeDirect("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttributeDirect("marginheight");
    }

    public final String getNoResizeAttribute() {
        return this.getAttributeDirect("noresize");
    }

    public final String getScrollingAttribute() {
        return this.getAttributeDirect("scrolling");
    }

    public final String getOnLoadAttribute() {
        return this.getAttributeDirect("onload");
    }

    public Page getEnclosedPage() {
        return this.getEnclosedWindow().getEnclosedPage();
    }

    public FrameWindow getEnclosedWindow() {
        return this.enclosedWindow_;
    }

    public final void setSrcAttribute(String attribute) {
        this.setAttribute("src", attribute);
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObserver) {
        if (null != attributeValue && "src".equals(qualifiedName)) {
            attributeValue = attributeValue.trim();
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObserver);
        if ("src".equals(qualifiedName) && "about:blank" != attributeValue) {
            if (this.isAttachedToPage()) {
                this.loadSrc();
            } else {
                this.loadSrcWhenAddedToPage_ = true;
            }
        }
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        String qualifiedName = attribute.getName();
        String attributeValue = null;
        if ("src".equals(qualifiedName)) {
            attributeValue = attribute.getValue().trim();
        }
        Attr result = super.setAttributeNode(attribute);
        if ("src".equals(qualifiedName) && !"about:blank".equals(attributeValue)) {
            if (this.isAttachedToPage()) {
                this.loadSrc();
            } else {
                this.loadSrcWhenAddedToPage_ = true;
            }
        }
        return result;
    }

    private void loadSrc() {
        this.loadSrcWhenAddedToPage_ = false;
        final String src = this.getSrcAttribute();
        AbstractJavaScriptEngine<?> jsEngine = this.getPage().getWebClient().getJavaScriptEngine();
        if (!jsEngine.isScriptRunning() || src.startsWith("javascript:")) {
            this.loadInnerPageIfPossible(src);
        } else {
            final Page pageInFrame = this.getEnclosedPage();
            PostponedAction action = new PostponedAction(this.getPage()){

                @Override
                public void execute() throws Exception {
                    if (!src.isEmpty() && BaseFrameElement.this.getSrcAttribute().equals(src)) {
                        BaseFrameElement.this.loadInnerPage();
                    }
                }

                @Override
                public boolean isStillAlive() {
                    return super.isStillAlive() && pageInFrame == BaseFrameElement.this.getEnclosedPage();
                }
            };
            jsEngine.addPostponedAction(action);
        }
    }

    @Override
    protected void onAddedToPage() {
        super.onAddedToPage();
        if (this.loadSrcWhenAddedToPage_) {
            this.loadSrc();
        }
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public void unmarkAsCreatedByJavascript() {
        this.createdByJavascript_ = false;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        BaseFrameElement clone = (BaseFrameElement)super.cloneNode(deep);
        clone.init();
        return clone;
    }

    @Override
    public void remove() {
        super.remove();
        this.getEnclosedWindow().close();
    }
}

