/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DeletedColumn
extends Column {
    public DeletedColumn(ByteBuffer name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public DeletedColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public boolean isMarkedForDelete() {
        return true;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value.getInt(this.value.position());
    }

    @Override
    public IColumn reconcile(IColumn column) {
        if (column instanceof DeletedColumn) {
            return super.reconcile(column);
        }
        return column.reconcile(this);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return new DeletedColumn(cfs.internOrCopy(this.name), ByteBufferUtil.clone(this.value), this.timestamp);
    }

    @Override
    public int serializationFlags() {
        return 1;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if (this.value().remaining() != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }
}

