/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DoubleType
extends AbstractType<Double> {
    public static final DoubleType instance = new DoubleType();

    DoubleType() {
    }

    @Override
    public Double compose(ByteBuffer bytes) {
        return ByteBufferUtil.toDouble(bytes);
    }

    @Override
    public ByteBuffer decompose(Double value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return this.compose(o1).compareTo(this.compose(o2));
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A double is exactly 8 bytes : " + bytes.remaining());
        }
        return this.compose(bytes).toString();
    }

    @Override
    public String toString(Double d) {
        return d.toString();
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        Double d;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            d = Double.parseDouble(source);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("unable to coerce '%s' to a double", source), e1);
        }
        return this.decompose(d);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte value for a double (%d)", bytes.remaining()));
        }
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public int getPrecision(Double obj) {
        return 15;
    }

    @Override
    public int getScale(Double obj) {
        return 300;
    }

    @Override
    public int getJdbcType() {
        return 8;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }
}

