/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatType
extends AbstractType<Float> {
    public static final FloatType instance = new FloatType();

    FloatType() {
    }

    @Override
    public Float compose(ByteBuffer bytes) {
        return Float.valueOf(ByteBufferUtil.toFloat(bytes));
    }

    @Override
    public ByteBuffer decompose(Float value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.floatValue());
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return this.compose(o1).compareTo(this.compose(o2));
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 4) {
            throw new MarshalException("A float is exactly 4 bytes : " + bytes.remaining());
        }
        return this.compose(bytes).toString();
    }

    @Override
    public String toString(Float d) {
        return d.toString();
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        Float f;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            f = Float.valueOf(Float.parseFloat(source));
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("unable to coerce '%s' to a float", source), e1);
        }
        return ByteBufferUtil.bytes(f.floatValue());
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 4 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 4 or 0 byte value for a float (%d)", bytes.remaining()));
        }
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public int getPrecision(Float obj) {
        return 7;
    }

    @Override
    public int getScale(Float obj) {
        return 40;
    }

    @Override
    public int getJdbcType() {
        return 6;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }
}

