/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.AbstractCType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractCellNameType
extends AbstractCType
implements CellNameType {
    final Comparator<Cell> columnComparator = new Comparator<Cell>(){

        @Override
        public int compare(Cell c1, Cell c2) {
            return AbstractCellNameType.this.compare(c1.name(), c2.name());
        }
    };
    private final Comparator<Cell> columnReverseComparator;
    final Comparator<Object> asymmetricComparator = new Comparator<Object>(){

        @Override
        public int compare(Object c1, Object c2) {
            return AbstractCellNameType.this.compare((Composite)c1, ((Cell)c2).name());
        }
    };
    private final Comparator<OnDiskAtom> onDiskAtomComparator;
    private final ISerializer<CellName> cellSerializer;
    private final ColumnSerializer columnSerializer;
    private final OnDiskAtom.Serializer onDiskAtomSerializer;
    private final IVersionedSerializer<NamesQueryFilter> namesQueryFilterSerializer;
    private final IVersionedSerializer<IDiskAtomFilter> diskAtomFilterSerializer;

    protected AbstractCellNameType(boolean isByteOrderComparable) {
        super(isByteOrderComparable);
        this.columnReverseComparator = new Comparator<Cell>(){

            @Override
            public int compare(Cell c1, Cell c2) {
                return AbstractCellNameType.this.compare(c2.name(), c1.name());
            }
        };
        this.onDiskAtomComparator = new Comparator<OnDiskAtom>(){

            @Override
            public int compare(OnDiskAtom c1, OnDiskAtom c2) {
                int comp = AbstractCellNameType.this.compare(c1.name(), c2.name());
                if (comp != 0) {
                    return comp;
                }
                if (c1 instanceof RangeTombstone) {
                    if (c2 instanceof RangeTombstone) {
                        RangeTombstone t1 = (RangeTombstone)c1;
                        RangeTombstone t2 = (RangeTombstone)c2;
                        int comp2 = AbstractCellNameType.this.compare((Composite)t1.max, (Composite)t2.max);
                        return comp2 == 0 ? ((DeletionTime)t1.data).compareTo((DeletionTime)t2.data) : comp2;
                    }
                    return -1;
                }
                return c2 instanceof RangeTombstone ? 1 : 0;
            }
        };
        this.cellSerializer = new ISerializer<CellName>(){

            @Override
            public void serialize(CellName c, DataOutputPlus out) throws IOException {
                AbstractCellNameType.this.serializer().serialize(c, out);
            }

            @Override
            public CellName deserialize(DataInput in) throws IOException {
                Composite ct = (Composite)AbstractCellNameType.this.serializer().deserialize(in);
                if (ct.isEmpty()) {
                    throw ColumnSerializer.CorruptColumnException.create(in, ByteBufferUtil.EMPTY_BYTE_BUFFER);
                }
                assert (ct instanceof CellName) : ct;
                return (CellName)ct;
            }

            @Override
            public long serializedSize(CellName c, TypeSizes type) {
                return AbstractCellNameType.this.serializer().serializedSize(c, type);
            }
        };
        this.columnSerializer = new ColumnSerializer(this);
        this.onDiskAtomSerializer = new OnDiskAtom.Serializer(this);
        this.namesQueryFilterSerializer = new NamesQueryFilter.Serializer(this);
        this.diskAtomFilterSerializer = new IDiskAtomFilter.Serializer(this);
    }

    @Override
    public final Comparator<Cell> columnComparator(boolean isRightNative) {
        if (!this.isByteOrderComparable) {
            return this.columnComparator;
        }
        return this.getByteOrderColumnComparator(isRightNative);
    }

    @Override
    public final Comparator<Object> asymmetricColumnComparator(boolean isRightNative) {
        if (!this.isByteOrderComparable) {
            return this.asymmetricComparator;
        }
        return this.getByteOrderAsymmetricColumnComparator(isRightNative);
    }

    @Override
    public Comparator<Cell> columnReverseComparator() {
        return this.columnReverseComparator;
    }

    @Override
    public Comparator<OnDiskAtom> onDiskAtomComparator() {
        return this.onDiskAtomComparator;
    }

    @Override
    public ISerializer<CellName> cellSerializer() {
        return this.cellSerializer;
    }

    @Override
    public ColumnSerializer columnSerializer() {
        return this.columnSerializer;
    }

    @Override
    public OnDiskAtom.Serializer onDiskAtomSerializer() {
        return this.onDiskAtomSerializer;
    }

    @Override
    public IVersionedSerializer<NamesQueryFilter> namesQueryFilterSerializer() {
        return this.namesQueryFilterSerializer;
    }

    @Override
    public IVersionedSerializer<IDiskAtomFilter> diskAtomFilterSerializer() {
        return this.diskAtomFilterSerializer;
    }

    @Override
    public CellName cellFromByteBuffer(ByteBuffer bytes) {
        return (CellName)this.fromByteBuffer(bytes);
    }

    @Override
    public CellName create(Composite prefix, ColumnDefinition column, ByteBuffer collectionElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellName rowMarker(Composite prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Composite staticPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCollections() {
        return false;
    }

    @Override
    public boolean supportCollections() {
        return false;
    }

    @Override
    public ColumnToCollectionType collectionType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellNameType addOrUpdateCollection(ColumnIdentifier columnName, CollectionType newCollection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Composite make(Object ... components) {
        return components.length == this.size() ? this.makeCellName(components) : super.make(components);
    }

    @Override
    public CellName makeCellName(Object ... components) {
        ByteBuffer[] rawComponents = new ByteBuffer[components.length];
        for (int i = 0; i < components.length; ++i) {
            Object c = components[i];
            if (c instanceof ByteBuffer) {
                rawComponents[i] = (ByteBuffer)c;
                continue;
            }
            AbstractType<?> type = this.subtype(i);
            if (type instanceof ColumnToCollectionType) {
                assert (i > 0);
                type = ((ColumnToCollectionType)type).defined.get(rawComponents[i - 1]).nameComparator();
            }
            rawComponents[i] = type.decompose(c);
        }
        return this.makeCellName(rawComponents);
    }

    protected abstract CellName makeCellName(ByteBuffer[] var1);

    protected static CQL3Row.Builder makeDenseCQL3RowBuilder(final long now) {
        return new CQL3Row.Builder(){

            @Override
            public CQL3Row.RowIterator group(Iterator<Cell> cells) {
                return new DenseRowIterator(cells, now);
            }
        };
    }

    protected static CQL3Row.Builder makeSparseCQL3RowBuilder(final CFMetaData cfMetaData, final CellNameType type, final long now) {
        return new CQL3Row.Builder(){

            @Override
            public CQL3Row.RowIterator group(Iterator<Cell> cells) {
                return new SparseRowIterator(cfMetaData, type, cells, now);
            }
        };
    }

    private static class CQL3RowOfSparse
    implements CQL3Row {
        private final CFMetaData cfMetaData;
        private final CellName cell;
        private Map<ColumnIdentifier, Cell> columns;
        private Map<ColumnIdentifier, List<Cell>> collections;

        CQL3RowOfSparse(CFMetaData metadata, CellName cell) {
            this.cfMetaData = metadata;
            this.cell = cell;
        }

        @Override
        public ByteBuffer getClusteringColumn(int i) {
            return this.cell.get(i);
        }

        void add(Cell cell) {
            CellName cellName = cell.name();
            ColumnIdentifier columnName = cellName.cql3ColumnName(this.cfMetaData);
            if (cellName.isCollectionCell()) {
                List<Cell> values;
                if (this.collections == null) {
                    this.collections = new HashMap<ColumnIdentifier, List<Cell>>();
                }
                if ((values = this.collections.get(columnName)) == null) {
                    values = new ArrayList<Cell>();
                    this.collections.put(columnName, values);
                }
                values.add(cell);
            } else {
                if (this.columns == null) {
                    this.columns = new HashMap<ColumnIdentifier, Cell>();
                }
                this.columns.put(columnName, cell);
            }
        }

        @Override
        public Cell getColumn(ColumnIdentifier name) {
            return this.columns == null ? null : this.columns.get(name);
        }

        @Override
        public List<Cell> getMultiCellColumn(ColumnIdentifier name) {
            return this.collections == null ? null : this.collections.get(name);
        }
    }

    private static class SparseRowIterator
    extends AbstractIterator<CQL3Row>
    implements CQL3Row.RowIterator {
        private final CFMetaData cfMetaData;
        private final CellNameType type;
        private final Iterator<Cell> cells;
        private final long now;
        private final CQL3Row staticRow;
        private Cell nextCell;
        private CellName previous;
        private CQL3RowOfSparse currentRow;

        public SparseRowIterator(CFMetaData cfMetaData, CellNameType type, Iterator<Cell> cells, long now) {
            this.cfMetaData = cfMetaData;
            this.type = type;
            this.cells = cells;
            this.now = now;
            this.staticRow = this.hasNextCell() && this.nextCell.name().isStatic() ? this.computeNext() : null;
        }

        @Override
        public CQL3Row getStaticRow() {
            return this.staticRow;
        }

        private boolean hasNextCell() {
            if (this.nextCell != null) {
                return true;
            }
            while (this.cells.hasNext()) {
                Cell cell = this.cells.next();
                if (!cell.isLive(this.now)) continue;
                this.nextCell = cell;
                return true;
            }
            return false;
        }

        protected CQL3Row computeNext() {
            CQL3RowOfSparse toReturn;
            while (this.hasNextCell()) {
                toReturn = null;
                CellName current = this.nextCell.name();
                if (this.currentRow == null || !current.isSameCQL3RowAs(this.type, this.previous)) {
                    toReturn = this.currentRow;
                    this.currentRow = new CQL3RowOfSparse(this.cfMetaData, current);
                }
                this.currentRow.add(this.nextCell);
                this.nextCell = null;
                this.previous = current;
                if (toReturn == null) continue;
                return toReturn;
            }
            if (this.currentRow != null) {
                toReturn = this.currentRow;
                this.currentRow = null;
                return toReturn;
            }
            return (CQL3Row)this.endOfData();
        }
    }

    private static class DenseRowIterator
    extends AbstractIterator<CQL3Row>
    implements CQL3Row.RowIterator {
        private final Iterator<Cell> cells;
        private final long now;

        public DenseRowIterator(Iterator<Cell> cells, long now) {
            this.cells = cells;
            this.now = now;
        }

        @Override
        public CQL3Row getStaticRow() {
            return null;
        }

        protected CQL3Row computeNext() {
            while (this.cells.hasNext()) {
                final Cell cell = this.cells.next();
                if (!cell.isLive(this.now)) continue;
                return new CQL3Row(){

                    @Override
                    public ByteBuffer getClusteringColumn(int i) {
                        return cell.name().get(i);
                    }

                    @Override
                    public Cell getColumn(ColumnIdentifier name) {
                        return cell;
                    }

                    @Override
                    public List<Cell> getMultiCellColumn(ColumnIdentifier name) {
                        return null;
                    }
                };
            }
            return (CQL3Row)this.endOfData();
        }
    }
}

