/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public interface ClusteringPrefix
extends IMeasurableMemory,
Clusterable {
    public static final Serializer serializer = new Serializer();

    public Kind kind();

    public int size();

    public ByteBuffer get(int var1);

    public void digest(MessageDigest var1);

    public int dataSize();

    public String toString(CFMetaData var1);

    public ByteBuffer[] getRawValues();

    public static class Deserializer {
        private final ClusteringComparator comparator;
        private final DataInputPlus in;
        private final SerializationHeader serializationHeader;
        private boolean nextIsRow;
        private long nextHeader;
        private int nextSize;
        private Kind nextKind;
        private int deserializedSize;
        private ByteBuffer[] nextValues;

        public Deserializer(ClusteringComparator comparator, DataInputPlus in, SerializationHeader header) {
            this.comparator = comparator;
            this.in = in;
            this.serializationHeader = header;
        }

        public void prepare(int flags, int extendedFlags) throws IOException {
            if (UnfilteredSerializer.isStatic(extendedFlags)) {
                throw new IOException("Corrupt flags value for clustering prefix (isStatic flag set): " + flags);
            }
            this.nextIsRow = UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW;
            this.nextKind = this.nextIsRow ? Kind.CLUSTERING : Kind.values()[this.in.readByte()];
            this.nextSize = this.nextIsRow ? this.comparator.size() : this.in.readUnsignedShort();
            this.deserializedSize = 0;
            if (this.nextValues == null || this.nextValues.length != this.nextSize) {
                this.nextValues = new ByteBuffer[this.nextSize];
            }
        }

        public int compareNextTo(ClusteringBoundOrBoundary bound) throws IOException {
            if (bound == ClusteringBound.TOP) {
                return -1;
            }
            for (int i = 0; i < bound.size(); ++i) {
                if (!this.hasComponent(i)) {
                    return this.nextKind.comparedToClustering;
                }
                int cmp = this.comparator.compareComponent(i, this.nextValues[i], bound.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            if (bound.size() == this.nextSize) {
                return Kind.compare(this.nextKind, bound.kind());
            }
            return -bound.kind().comparedToClustering;
        }

        private boolean hasComponent(int i) throws IOException {
            if (i >= this.nextSize) {
                return false;
            }
            while (this.deserializedSize <= i) {
                this.deserializeOne();
            }
            return true;
        }

        private boolean deserializeOne() throws IOException {
            int i;
            if (this.deserializedSize == this.nextSize) {
                return false;
            }
            if (this.deserializedSize % 32 == 0) {
                this.nextHeader = this.in.readUnsignedVInt();
            }
            ByteBuffer byteBuffer = Serializer.isNull(this.nextHeader, i = this.deserializedSize++) ? null : (Serializer.isEmpty(this.nextHeader, i) ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.serializationHeader.clusteringTypes().get(i).readValue(this.in, DatabaseDescriptor.getMaxValueSize()));
            this.nextValues[i] = byteBuffer;
            return true;
        }

        private void deserializeAll() throws IOException {
            while (this.deserializeOne()) {
            }
        }

        public ClusteringBoundOrBoundary deserializeNextBound() throws IOException {
            assert (!this.nextIsRow);
            this.deserializeAll();
            ClusteringBoundOrBoundary bound = ClusteringBoundOrBoundary.create(this.nextKind, this.nextValues);
            this.nextValues = null;
            return bound;
        }

        public Clustering deserializeNextClustering() throws IOException {
            assert (this.nextIsRow);
            this.deserializeAll();
            Clustering clustering = Clustering.make(this.nextValues);
            this.nextValues = null;
            return clustering;
        }

        public Kind skipNext() throws IOException {
            for (int i = this.deserializedSize; i < this.nextSize; ++i) {
                if (i % 32 == 0) {
                    this.nextHeader = this.in.readUnsignedVInt();
                }
                if (Serializer.isNull(this.nextHeader, i) || Serializer.isEmpty(this.nextHeader, i)) continue;
                this.serializationHeader.clusteringTypes().get(i).skipValue(this.in);
            }
            this.deserializedSize = this.nextSize;
            return this.nextKind;
        }
    }

    public static class Serializer {
        public void serialize(ClusteringPrefix clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            assert (clustering.kind() != Kind.STATIC_CLUSTERING);
            if (clustering.kind() == Kind.CLUSTERING) {
                out.writeByte(clustering.kind().ordinal());
                Clustering.serializer.serialize((Clustering)clustering, out, version, types);
            } else {
                ClusteringBoundOrBoundary.serializer.serialize((ClusteringBoundOrBoundary)clustering, out, version, types);
            }
        }

        public void skip(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            assert (kind != Kind.STATIC_CLUSTERING);
            if (kind == Kind.CLUSTERING) {
                Clustering.serializer.skip(in, version, types);
            } else {
                ClusteringBoundOrBoundary.serializer.skipValues(in, kind, version, types);
            }
        }

        public ClusteringPrefix deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            assert (kind != Kind.STATIC_CLUSTERING);
            if (kind == Kind.CLUSTERING) {
                return Clustering.serializer.deserialize(in, version, types);
            }
            return ClusteringBoundOrBoundary.serializer.deserializeValues(in, kind, version, types);
        }

        public long serializedSize(ClusteringPrefix clustering, int version, List<AbstractType<?>> types) {
            assert (clustering.kind() != Kind.STATIC_CLUSTERING);
            if (clustering.kind() == Kind.CLUSTERING) {
                return 1L + Clustering.serializer.serializedSize((Clustering)clustering, version, types);
            }
            return ClusteringBoundOrBoundary.serializer.serializedSize((ClusteringBoundOrBoundary)clustering, version, types);
        }

        void serializeValuesWithoutSize(ClusteringPrefix clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            int offset = 0;
            int clusteringSize = clustering.size();
            while (offset < clusteringSize) {
                int limit = Math.min(clusteringSize, offset + 32);
                out.writeUnsignedVInt(Serializer.makeHeader(clustering, offset, limit));
                while (offset < limit) {
                    ByteBuffer v = clustering.get(offset);
                    if (v != null && v.hasRemaining()) {
                        types.get(offset).writeValue(v, out);
                    }
                    ++offset;
                }
            }
        }

        long valuesWithoutSizeSerializedSize(ClusteringPrefix clustering, int version, List<AbstractType<?>> types) {
            long result = 0L;
            int offset = 0;
            int clusteringSize = clustering.size();
            while (offset < clusteringSize) {
                int limit = Math.min(clusteringSize, offset + 32);
                result += (long)TypeSizes.sizeofUnsignedVInt(Serializer.makeHeader(clustering, offset, limit));
                offset = limit;
            }
            for (int i = 0; i < clusteringSize; ++i) {
                ByteBuffer v = clustering.get(i);
                if (v == null || !v.hasRemaining()) continue;
                result += types.get(i).writtenLength(v);
            }
            return result;
        }

        ByteBuffer[] deserializeValuesWithoutSize(DataInputPlus in, int size, int version, List<AbstractType<?>> types) throws IOException {
            assert (size > 0);
            ByteBuffer[] values = new ByteBuffer[size];
            int offset = 0;
            while (offset < size) {
                long header = in.readUnsignedVInt();
                int limit = Math.min(size, offset + 32);
                while (offset < limit) {
                    values[offset] = Serializer.isNull(header, offset) ? null : (Serializer.isEmpty(header, offset) ? ByteBufferUtil.EMPTY_BYTE_BUFFER : types.get(offset).readValue(in, DatabaseDescriptor.getMaxValueSize()));
                    ++offset;
                }
            }
            return values;
        }

        void skipValuesWithoutSize(DataInputPlus in, int size, int version, List<AbstractType<?>> types) throws IOException {
            assert (size > 0);
            int offset = 0;
            while (offset < size) {
                long header = in.readUnsignedVInt();
                int limit = Math.min(size, offset + 32);
                while (offset < limit) {
                    if (!Serializer.isNull(header, offset) && !Serializer.isEmpty(header, offset)) {
                        types.get(offset).skipValue(in);
                    }
                    ++offset;
                }
            }
        }

        private static long makeHeader(ClusteringPrefix clustering, int offset, int limit) {
            long header = 0L;
            for (int i = offset; i < limit; ++i) {
                ByteBuffer v = clustering.get(i);
                if (v == null) {
                    header |= 1L << i * 2 + 1;
                    continue;
                }
                if (v.hasRemaining()) continue;
                header |= 1L << i * 2;
            }
            return header;
        }

        private static boolean isNull(long header, int i) {
            long mask = 1L << i * 2 + 1;
            return (header & mask) != 0L;
        }

        private static boolean isEmpty(long header, int i) {
            long mask = 1L << i * 2;
            return (header & mask) != 0L;
        }
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind EXCL_END_BOUND = new Kind(0, -1);
        public static final /* enum */ Kind INCL_START_BOUND = new Kind(0, -1);
        public static final /* enum */ Kind EXCL_END_INCL_START_BOUNDARY = new Kind(0, -1);
        public static final /* enum */ Kind STATIC_CLUSTERING = new Kind(1, -1);
        public static final /* enum */ Kind CLUSTERING = new Kind(2, 0);
        public static final /* enum */ Kind INCL_END_EXCL_START_BOUNDARY = new Kind(3, 1);
        public static final /* enum */ Kind INCL_END_BOUND = new Kind(3, 1);
        public static final /* enum */ Kind EXCL_START_BOUND = new Kind(3, 1);
        private final int comparison;
        public final int comparedToClustering;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind(int comparison, int comparedToClustering) {
            this.comparison = comparison;
            this.comparedToClustering = comparedToClustering;
        }

        public static int compare(Kind k1, Kind k2) {
            return Integer.compare(k1.comparison, k2.comparison);
        }

        public Kind invert() {
            switch (this) {
                case EXCL_START_BOUND: {
                    return INCL_END_BOUND;
                }
                case INCL_START_BOUND: {
                    return EXCL_END_BOUND;
                }
                case EXCL_END_BOUND: {
                    return INCL_START_BOUND;
                }
                case INCL_END_BOUND: {
                    return EXCL_START_BOUND;
                }
                case EXCL_END_INCL_START_BOUNDARY: {
                    return INCL_END_EXCL_START_BOUNDARY;
                }
                case INCL_END_EXCL_START_BOUNDARY: {
                    return EXCL_END_INCL_START_BOUNDARY;
                }
            }
            return this;
        }

        public boolean isBound() {
            switch (this) {
                case EXCL_START_BOUND: 
                case INCL_START_BOUND: 
                case EXCL_END_BOUND: 
                case INCL_END_BOUND: {
                    return true;
                }
            }
            return false;
        }

        public boolean isBoundary() {
            switch (this) {
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isStart() {
            switch (this) {
                case EXCL_START_BOUND: 
                case INCL_START_BOUND: 
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isEnd() {
            switch (this) {
                case EXCL_END_BOUND: 
                case INCL_END_BOUND: 
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isOpen(boolean reversed) {
            return this.isBoundary() || (reversed ? this.isEnd() : this.isStart());
        }

        public boolean isClose(boolean reversed) {
            return this.isBoundary() || (reversed ? this.isStart() : this.isEnd());
        }

        public Kind closeBoundOfBoundary(boolean reversed) {
            assert (this.isBoundary());
            return reversed ? (this == INCL_END_EXCL_START_BOUNDARY ? EXCL_START_BOUND : INCL_START_BOUND) : (this == INCL_END_EXCL_START_BOUNDARY ? INCL_END_BOUND : EXCL_END_BOUND);
        }

        public Kind openBoundOfBoundary(boolean reversed) {
            assert (this.isBoundary());
            return reversed ? (this == INCL_END_EXCL_START_BOUNDARY ? INCL_END_BOUND : EXCL_END_BOUND) : (this == INCL_END_EXCL_START_BOUNDARY ? EXCL_START_BOUND : INCL_START_BOUND);
        }

        static {
            $VALUES = new Kind[]{EXCL_END_BOUND, INCL_START_BOUND, EXCL_END_INCL_START_BOUNDARY, STATIC_CLUSTERING, CLUSTERING, INCL_END_EXCL_START_BOUNDARY, INCL_END_BOUND, EXCL_START_BOUND};
        }
    }
}

