/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.protostuff.Wrapper;
import org.apache.dubbo.common.serialize.protostuff.utils.WrapperUtils;

public class ProtostuffObjectOutput
implements ObjectOutput {
    private LinkedBuffer buffer = LinkedBuffer.allocate();
    private DataOutputStream dos;

    public ProtostuffObjectOutput(OutputStream outputStream) {
        this.dos = new DataOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object obj) throws IOException {
        byte[] classNameBytes;
        byte[] bytes;
        try {
            if (WrapperUtils.needWrapper(obj)) {
                Schema schema = RuntimeSchema.getSchema(Wrapper.class);
                Wrapper<Object> wrapper = new Wrapper<Object>(obj);
                bytes = ProtobufIOUtil.toByteArray(wrapper, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = Wrapper.class.getName().getBytes();
            } else {
                Schema schema = RuntimeSchema.getSchema(obj.getClass());
                bytes = ProtobufIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = obj.getClass().getName().getBytes();
            }
        }
        finally {
            this.buffer.clear();
        }
        this.dos.writeInt(classNameBytes.length);
        this.dos.writeInt(bytes.length);
        this.dos.write(classNameBytes);
        this.dos.write(bytes);
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.dos.writeByte(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.dos.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        byte[] bytes = v.getBytes();
        this.dos.writeInt(bytes.length);
        this.dos.write(bytes);
    }

    @Override
    public void writeBytes(byte[] v) throws IOException {
        this.dos.writeInt(v.length);
        this.dos.write(v);
    }

    @Override
    public void writeBytes(byte[] v, int off, int len) throws IOException {
        this.dos.writeInt(len);
        byte[] bytes = new byte[len];
        System.arraycopy(v, off, bytes, 0, len);
        this.dos.write(bytes);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.dos.flush();
    }
}

