/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;

public class ReconnectTimerTask
extends AbstractTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ReconnectTimerTask.class);
    private final int heartbeatTimeout;

    ReconnectTimerTask(AbstractTimerTask.ChannelProvider channelProvider, Long heartbeatTimeoutTick, int heartbeatTimeout1) {
        super(channelProvider, heartbeatTimeoutTick);
        this.heartbeatTimeout = heartbeatTimeout1;
    }

    @Override
    protected void doTask(Channel channel) {
        try {
            Long lastRead = ReconnectTimerTask.lastRead(channel);
            Long now = ReconnectTimerTask.now();
            if (lastRead != null && now - lastRead > (long)this.heartbeatTimeout) {
                logger.warn("Close channel " + channel + ", because heartbeat read idle time out: " + this.heartbeatTimeout + "ms");
                if (channel instanceof Client) {
                    try {
                        ((Client)channel).reconnect();
                    }
                    catch (Exception exception) {}
                } else {
                    channel.close();
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Exception when reconnect to remote channel " + channel.getRemoteAddress(), t);
        }
    }
}

