/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.zkclient;

import java.util.List;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.support.AbstractZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.zkclient.ZkClientWrapper;
import org.apache.zookeeper.Watcher;

public class ZkclientZookeeperClient
extends AbstractZookeeperClient<IZkChildListener> {
    private Logger logger = LoggerFactory.getLogger(ZkclientZookeeperClient.class);
    private final ZkClientWrapper client;
    private volatile Watcher.Event.KeeperState state = Watcher.Event.KeeperState.SyncConnected;

    public ZkclientZookeeperClient(URL url) {
        super(url);
        long timeout = url.getParameter("timeout", 30000L);
        this.client = new ZkClientWrapper(url.getBackupAddress(), timeout);
        this.client.addListener(new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                ZkclientZookeeperClient.this.state = state;
                if (state == Watcher.Event.KeeperState.Disconnected) {
                    ZkclientZookeeperClient.this.stateChanged(0);
                } else if (state == Watcher.Event.KeeperState.SyncConnected) {
                    ZkclientZookeeperClient.this.stateChanged(1);
                }
            }

            public void handleNewSession() throws Exception {
                ZkclientZookeeperClient.this.stateChanged(2);
            }
        });
        this.client.start();
    }

    @Override
    public void createPersistent(String path) {
        try {
            this.client.createPersistent(path);
        }
        catch (ZkNodeExistsException e) {
            this.logger.error("zookeeper failed to create persistent node with " + path + ": ", e);
        }
    }

    @Override
    public void createEphemeral(String path) {
        try {
            this.client.createEphemeral(path);
        }
        catch (ZkNodeExistsException e) {
            this.logger.error("zookeeper failed to create ephemeral node with " + path + ": ", e);
        }
    }

    @Override
    protected void createPersistent(String path, String data) {
        try {
            this.client.createPersistent(path, data);
        }
        catch (ZkNodeExistsException e) {
            this.logger.error("zookeeper failed to create persistent node with " + path + " and " + data + " : ", e);
        }
    }

    @Override
    protected void createEphemeral(String path, String data) {
        try {
            this.client.createEphemeral(path, data);
        }
        catch (ZkNodeExistsException e) {
            this.logger.error("zookeeper failed to create ephemeral node with " + path + " and " + data + " : ", e);
        }
    }

    @Override
    public void delete(String path) {
        try {
            this.client.delete(path);
        }
        catch (ZkNoNodeException e) {
            this.logger.error("zookeeper failed to delete node with " + path + ": ", e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return this.client.getChildren(path);
        }
        catch (ZkNoNodeException e) {
            this.logger.error("zookeeper failed to get children node with " + path + ": ", e);
            return null;
        }
    }

    @Override
    public boolean checkExists(String path) {
        try {
            return this.client.exists(path);
        }
        catch (Throwable t) {
            this.logger.error("zookeeper failed to check node existing with " + path + ": ", t);
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.state == Watcher.Event.KeeperState.SyncConnected;
    }

    @Override
    public String doGetContent(String path) {
        try {
            return this.client.getData(path);
        }
        catch (ZkNoNodeException e) {
            this.logger.error("zookeeper failed to get data with " + path + ": ", e);
            return null;
        }
    }

    @Override
    public void doClose() {
        this.client.close();
    }

    @Override
    public IZkChildListener createTargetChildListener(String path, ChildListener listener) {
        return listener::childChanged;
    }

    @Override
    public List<String> addTargetChildListener(String path, IZkChildListener listener) {
        return this.client.subscribeChildChanges(path, listener);
    }

    @Override
    public void removeTargetChildListener(String path, IZkChildListener listener) {
        this.client.unsubscribeChildChanges(path, listener);
    }
}

