/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.file;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;

public class FileRouterFactory
implements RouterFactory {
    public static final String NAME = "file";
    private RouterFactory routerFactory;

    public void setRouterFactory(RouterFactory routerFactory) {
        this.routerFactory = routerFactory;
    }

    @Override
    public Router getRouter(URL url) {
        try {
            int i;
            String protocol = url.getParameter("router", "script");
            String type = null;
            String path = url.getPath();
            if (path != null && (i = path.lastIndexOf(46)) > 0) {
                type = path.substring(i + 1);
            }
            String rule = IOUtils.read(new FileReader(new File(url.getAbsolutePath())));
            boolean runtime = url.getParameter("runtime", false);
            URL script = url.setProtocol(protocol).addParameter("type", type).addParameter("runtime", runtime).addParameterAndEncoded("rule", rule);
            return this.routerFactory.getRouter(script);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

