/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractMethodConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.metadata.integration.MetadataReportService;
import org.apache.dubbo.monitor.MonitorFactory;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.InvokerListener;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.MockInvoker;

public abstract class AbstractInterfaceConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = -1559314110797223229L;
    protected String local;
    protected String stub;
    protected MonitorConfig monitor;
    protected String proxy;
    protected String cluster;
    protected String filter;
    protected String listener;
    protected String owner;
    protected Integer connections;
    protected String layer;
    protected ApplicationConfig application;
    protected ModuleConfig module;
    protected List<RegistryConfig> registries;
    protected String registryIds;
    protected String onconnect;
    protected String ondisconnect;
    protected MetadataReportConfig metadataReportConfig;
    protected ConfigCenterConfig configCenter;
    private Integer callbacks;
    private String scope;

    protected void checkRegistry() {
        this.loadRegistriesFromBackwardConfig();
        this.convertRegistryIdsToRegistries();
        for (RegistryConfig registryConfig : this.registries) {
            if (registryConfig.isValid()) continue;
            throw new IllegalStateException("No registry config found or it's not a valid config! The registry config is: " + registryConfig);
        }
        this.useRegistryForConfigIfNecessary();
    }

    protected void checkApplication() {
        this.createApplicationIfAbsent();
        if (!this.application.isValid()) {
            throw new IllegalStateException("No application config found or it's not a valid config! Please add <dubbo:application name=\"...\" /> to your spring config.");
        }
        ApplicationModel.setApplication(this.application.getName());
        String wait = ConfigUtils.getProperty("dubbo.service.shutdown.wait");
        if (wait != null && wait.trim().length() > 0) {
            System.setProperty("dubbo.service.shutdown.wait", wait.trim());
        } else {
            wait = ConfigUtils.getProperty("dubbo.service.shutdown.wait.seconds");
            if (wait != null && wait.trim().length() > 0) {
                System.setProperty("dubbo.service.shutdown.wait.seconds", wait.trim());
            }
        }
    }

    protected void checkMonitor() {
        this.createMonitorIfAbsent();
        if (!this.monitor.isValid()) {
            logger.info("There's no valid monitor config found, if you want to open monitor statistics for Dubbo, please make sure your monitor is configured properly.");
        }
    }

    private void createMonitorIfAbsent() {
        if (this.monitor != null) {
            return;
        }
        ConfigManager configManager = ConfigManager.getInstance();
        this.setMonitor(configManager.getMonitor().orElseGet(() -> {
            MonitorConfig monitorConfig = new MonitorConfig();
            monitorConfig.refresh();
            return monitorConfig;
        }));
    }

    protected void checkMetadataReport() {
        if (this.metadataReportConfig == null) {
            this.setMetadataReportConfig(new MetadataReportConfig());
        }
        this.metadataReportConfig.refresh();
        if (!this.metadataReportConfig.isValid()) {
            logger.warn("There's no valid metadata config found, if you are using the simplified mode of registry url, please make sure you have a metadata address configured properly.");
        }
    }

    void startConfigCenter() {
        if (this.configCenter == null) {
            ConfigManager.getInstance().getConfigCenter().ifPresent(cc -> {
                this.configCenter = cc;
            });
        }
        if (this.configCenter != null) {
            this.configCenter.refresh();
            this.prepareEnvironment();
        }
        ConfigManager.getInstance().refreshAll();
    }

    private void prepareEnvironment() {
        if (this.configCenter.isValid()) {
            if (!this.configCenter.checkOrUpdateInited()) {
                return;
            }
            DynamicConfiguration dynamicConfiguration = this.getDynamicConfiguration(this.configCenter.toUrl());
            String configContent = dynamicConfiguration.getConfig(this.configCenter.getConfigFile(), this.configCenter.getGroup());
            String appGroup = this.application != null ? this.application.getName() : null;
            String appConfigContent = null;
            if (StringUtils.isNotEmpty(appGroup)) {
                appConfigContent = dynamicConfiguration.getConfig(StringUtils.isNotEmpty(this.configCenter.getAppConfigFile()) ? this.configCenter.getAppConfigFile() : this.configCenter.getConfigFile(), appGroup);
            }
            try {
                Environment.getInstance().setConfigCenterFirst(this.configCenter.isHighestPriority());
                Environment.getInstance().updateExternalConfigurationMap(ConfigurationUtils.parseProperties(configContent));
                Environment.getInstance().updateAppExternalConfigurationMap(ConfigurationUtils.parseProperties(appConfigContent));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
            }
        }
    }

    private DynamicConfiguration getDynamicConfiguration(URL url) {
        DynamicConfigurationFactory factories = ExtensionLoader.getExtensionLoader(DynamicConfigurationFactory.class).getExtension(url.getProtocol());
        DynamicConfiguration configuration = factories.getDynamicConfiguration(url);
        Environment.getInstance().setDynamicConfiguration(configuration);
        return configuration;
    }

    protected List<URL> loadRegistries(boolean provider) {
        ArrayList<URL> registryList = new ArrayList<URL>();
        if (CollectionUtils.isNotEmpty(this.registries)) {
            for (RegistryConfig config : this.registries) {
                String address = config.getAddress();
                if (StringUtils.isEmpty(address)) {
                    address = "0.0.0.0";
                }
                if ("N/A".equalsIgnoreCase(address)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                AbstractInterfaceConfig.appendParameters(map, this.application);
                AbstractInterfaceConfig.appendParameters(map, config);
                map.put("path", RegistryService.class.getName());
                AbstractInterfaceConfig.appendRuntimeParameters(map);
                if (!map.containsKey("protocol")) {
                    map.put("protocol", "dubbo");
                }
                List<URL> urls = UrlUtils.parseURLs(address, map);
                for (URL url : urls) {
                    url = URLBuilder.from(url).addParameter("registry", url.getProtocol()).setProtocol("registry").build();
                    if ((!provider || !url.getParameter("register", true)) && (provider || !url.getParameter("subscribe", true))) continue;
                    registryList.add(url);
                }
            }
        }
        return registryList;
    }

    protected URL loadMonitor(URL registryURL) {
        this.checkMonitor();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("interface", MonitorService.class.getName());
        AbstractInterfaceConfig.appendRuntimeParameters(map);
        String hostToRegistry = ConfigUtils.getSystemProperty("DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isEmpty(hostToRegistry)) {
            hostToRegistry = NetUtils.getLocalHost();
        }
        map.put("register.ip", hostToRegistry);
        AbstractInterfaceConfig.appendParameters(map, this.monitor);
        AbstractInterfaceConfig.appendParameters(map, this.application);
        String address = this.monitor.getAddress();
        String sysaddress = System.getProperty("dubbo.monitor.address");
        if (sysaddress != null && sysaddress.length() > 0) {
            address = sysaddress;
        }
        if (ConfigUtils.isNotEmpty(address)) {
            if (!map.containsKey("protocol")) {
                if (ExtensionLoader.getExtensionLoader(MonitorFactory.class).hasExtension("logstat")) {
                    map.put("protocol", "logstat");
                } else {
                    map.put("protocol", "dubbo");
                }
            }
            return UrlUtils.parseURL(address, map);
        }
        if ("registry".equals(this.monitor.getProtocol()) && registryURL != null) {
            return URLBuilder.from(registryURL).setProtocol("dubbo").addParameter("protocol", "registry").addParameterAndEncoded("refer", StringUtils.toQueryString(map)).build();
        }
        return null;
    }

    static void appendRuntimeParameters(Map<String, String> map) {
        map.put("dubbo", Version.getProtocolVersion());
        map.put("release", Version.getVersion());
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (ConfigUtils.getPid() > 0) {
            map.put("pid", String.valueOf(ConfigUtils.getPid()));
        }
    }

    private URL loadMetadataReporterURL() {
        String address = this.metadataReportConfig.getAddress();
        if (StringUtils.isEmpty(address)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        AbstractInterfaceConfig.appendParameters(map, this.metadataReportConfig);
        return UrlUtils.parseURL(address, map);
    }

    protected MetadataReportService getMetadataReportService() {
        if (this.metadataReportConfig == null || !this.metadataReportConfig.isValid()) {
            return null;
        }
        return MetadataReportService.instance(this::loadMetadataReporterURL);
    }

    protected void checkInterfaceAndMethods(Class<?> interfaceClass, List<MethodConfig> methods) {
        Assert.notNull(interfaceClass, new IllegalStateException("interface not allow null!"));
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        if (CollectionUtils.isNotEmpty(methods)) {
            for (MethodConfig methodBean : methods) {
                methodBean.setService(interfaceClass.getName());
                methodBean.setServiceId(this.getId());
                methodBean.refresh();
                String methodName = methodBean.getName();
                if (StringUtils.isEmpty(methodName)) {
                    throw new IllegalStateException("<dubbo:method> name attribute is required! Please check: <dubbo:service interface=\"" + interfaceClass.getName() + "\" ... ><dubbo:method name=\"\" ... /></<dubbo:reference>");
                }
                boolean hasMethod = Arrays.stream(interfaceClass.getMethods()).anyMatch(method -> method.getName().equals(methodName));
                if (hasMethod) continue;
                throw new IllegalStateException("The interface " + interfaceClass.getName() + " not found method " + methodName);
            }
        }
    }

    void checkMock(Class<?> interfaceClass) {
        if (ConfigUtils.isEmpty(this.mock)) {
            return;
        }
        String normalizedMock = MockInvoker.normalizeMock(this.mock);
        if (normalizedMock.startsWith("return ")) {
            normalizedMock = normalizedMock.substring("return ".length()).trim();
            try {
                MockInvoker.parseMockValue(normalizedMock);
            }
            catch (Exception e) {
                throw new IllegalStateException("Illegal mock return in <dubbo:service/reference ... mock=\"" + this.mock + "\" />");
            }
        } else if (normalizedMock.startsWith("throw")) {
            if (ConfigUtils.isNotEmpty(normalizedMock = normalizedMock.substring("throw".length()).trim())) {
                try {
                    MockInvoker.getThrowable(normalizedMock);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Illegal mock throw in <dubbo:service/reference ... mock=\"" + this.mock + "\" />");
                }
            }
        } else {
            MockInvoker.getMockObject(normalizedMock, interfaceClass);
        }
    }

    void checkStubAndLocal(Class<?> interfaceClass) {
        Class<?> localClass;
        if (ConfigUtils.isNotEmpty(this.local)) {
            localClass = ConfigUtils.isDefault(this.local) ? ReflectUtils.forName(interfaceClass.getName() + "Local") : ReflectUtils.forName(this.local);
            this.verify(interfaceClass, localClass);
        }
        if (ConfigUtils.isNotEmpty(this.stub)) {
            localClass = ConfigUtils.isDefault(this.stub) ? ReflectUtils.forName(interfaceClass.getName() + "Stub") : ReflectUtils.forName(this.stub);
            this.verify(interfaceClass, localClass);
        }
    }

    private void verify(Class<?> interfaceClass, Class<?> localClass) {
        if (!interfaceClass.isAssignableFrom(localClass)) {
            throw new IllegalStateException("The local implementation class " + localClass.getName() + " not implement interface " + interfaceClass.getName());
        }
        try {
            ReflectUtils.findConstructor(localClass, interfaceClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such constructor \"public " + localClass.getSimpleName() + "(" + interfaceClass.getName() + ")\" in local implementation class " + localClass.getName());
        }
    }

    private void convertRegistryIdsToRegistries() {
        if (StringUtils.isEmpty(this.registryIds) && CollectionUtils.isEmpty(this.registries)) {
            HashSet<String> configedRegistries = new HashSet<String>();
            configedRegistries.addAll(AbstractInterfaceConfig.getSubProperties(Environment.getInstance().getExternalConfigurationMap(), "dubbo.registries."));
            configedRegistries.addAll(AbstractInterfaceConfig.getSubProperties(Environment.getInstance().getAppExternalConfigurationMap(), "dubbo.registries."));
            this.registryIds = String.join((CharSequence)",", configedRegistries);
        }
        if (StringUtils.isEmpty(this.registryIds)) {
            if (CollectionUtils.isEmpty(this.registries)) {
                this.setRegistries(ConfigManager.getInstance().getDefaultRegistries().filter(CollectionUtils::isNotEmpty).orElseGet(() -> {
                    RegistryConfig registryConfig = new RegistryConfig();
                    registryConfig.refresh();
                    return Arrays.asList(registryConfig);
                }));
            }
        } else {
            String[] ids = Constants.COMMA_SPLIT_PATTERN.split(this.registryIds);
            ArrayList tmpRegistries = CollectionUtils.isNotEmpty(this.registries) ? this.registries : new ArrayList();
            Arrays.stream(ids).forEach(id -> {
                if (tmpRegistries.stream().noneMatch(reg -> reg.getId().equals(id))) {
                    tmpRegistries.add(ConfigManager.getInstance().getRegistry((String)id).orElseGet(() -> {
                        RegistryConfig registryConfig = new RegistryConfig();
                        registryConfig.setId((String)id);
                        registryConfig.refresh();
                        return registryConfig;
                    }));
                }
            });
            if (tmpRegistries.size() > ids.length) {
                throw new IllegalStateException("Too much registries found, the registries assigned to this service are :" + this.registryIds + ", but got " + tmpRegistries.size() + " registries!");
            }
            this.setRegistries(tmpRegistries);
        }
    }

    private void loadRegistriesFromBackwardConfig() {
        String address;
        if ((this.registries == null || this.registries.isEmpty()) && (address = ConfigUtils.getProperty("dubbo.registry.address")) != null && address.length() > 0) {
            String[] as;
            ArrayList<RegistryConfig> tmpRegistries = new ArrayList<RegistryConfig>();
            for (String a : as = address.split("\\s*[|]+\\s*")) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress(a);
                registryConfig.refresh();
                tmpRegistries.add(registryConfig);
            }
            this.setRegistries(tmpRegistries);
        }
    }

    private void useRegistryForConfigIfNecessary() {
        this.registries.stream().filter(RegistryConfig::isZookeeperProtocol).findFirst().ifPresent(rc -> Environment.getInstance().getDynamicConfiguration().orElseGet(() -> {
            ConfigManager configManager = ConfigManager.getInstance();
            ConfigCenterConfig cc = configManager.getConfigCenter().orElse(new ConfigCenterConfig());
            cc.setProtocol(rc.getProtocol());
            cc.setAddress(rc.getAddress());
            cc.setHighestPriority(false);
            this.setConfigCenter(cc);
            this.startConfigCenter();
            return null;
        }));
    }

    @Deprecated
    public String getLocal() {
        return this.local;
    }

    @Deprecated
    public void setLocal(Boolean local) {
        if (local == null) {
            this.setLocal((String)null);
        } else {
            this.setLocal(local.toString());
        }
    }

    @Deprecated
    public void setLocal(String local) {
        AbstractInterfaceConfig.checkName("local", local);
        this.local = local;
    }

    public String getStub() {
        return this.stub;
    }

    public void setStub(Boolean stub) {
        if (stub == null) {
            this.setStub((String)null);
        } else {
            this.setStub(stub.toString());
        }
    }

    public void setStub(String stub) {
        AbstractInterfaceConfig.checkName("stub", stub);
        this.stub = stub;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        AbstractInterfaceConfig.checkExtension(Cluster.class, "cluster", cluster);
        this.cluster = cluster;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        AbstractInterfaceConfig.checkExtension(ProxyFactory.class, "proxy", proxy);
        this.proxy = proxy;
    }

    public Integer getConnections() {
        return this.connections;
    }

    public void setConnections(Integer connections) {
        this.connections = connections;
    }

    @Parameter(key="reference.filter", append=true)
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        AbstractInterfaceConfig.checkMultiExtension(Filter.class, "filter", filter);
        this.filter = filter;
    }

    @Parameter(key="invoker.listener", append=true)
    public String getListener() {
        return this.listener;
    }

    public void setListener(String listener) {
        AbstractInterfaceConfig.checkMultiExtension(InvokerListener.class, "listener", listener);
        this.listener = listener;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        AbstractInterfaceConfig.checkNameHasSymbol("layer", layer);
        this.layer = layer;
    }

    public ApplicationConfig getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationConfig application) {
        ConfigManager.getInstance().setApplication(application);
        this.application = application;
    }

    private void createApplicationIfAbsent() {
        if (this.application != null) {
            return;
        }
        ConfigManager configManager = ConfigManager.getInstance();
        this.setApplication(configManager.getApplication().orElseGet(() -> {
            ApplicationConfig applicationConfig = new ApplicationConfig();
            applicationConfig.refresh();
            return applicationConfig;
        }));
    }

    public ModuleConfig getModule() {
        return this.module;
    }

    public void setModule(ModuleConfig module) {
        ConfigManager.getInstance().setModule(module);
        this.module = module;
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.setRegistries(registries);
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        ConfigManager.getInstance().addRegistries(registries);
        this.registries = registries;
    }

    @Parameter(excluded=true)
    public String getRegistryIds() {
        return this.registryIds;
    }

    public void setRegistryIds(String registryIds) {
        this.registryIds = registryIds;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(String monitor) {
        this.setMonitor(new MonitorConfig(monitor));
    }

    public void setMonitor(MonitorConfig monitor) {
        ConfigManager.getInstance().setMonitor(monitor);
        this.monitor = monitor;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        AbstractInterfaceConfig.checkMultiName("owner", owner);
        this.owner = owner;
    }

    public ConfigCenterConfig getConfigCenter() {
        return this.configCenter;
    }

    public void setConfigCenter(ConfigCenterConfig configCenter) {
        ConfigManager.getInstance().setConfigCenter(configCenter);
        this.configCenter = configCenter;
    }

    public Integer getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Integer callbacks) {
        this.callbacks = callbacks;
    }

    public String getOnconnect() {
        return this.onconnect;
    }

    public void setOnconnect(String onconnect) {
        this.onconnect = onconnect;
    }

    public String getOndisconnect() {
        return this.ondisconnect;
    }

    public void setOndisconnect(String ondisconnect) {
        this.ondisconnect = ondisconnect;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public MetadataReportConfig getMetadataReportConfig() {
        return this.metadataReportConfig;
    }

    public void setMetadataReportConfig(MetadataReportConfig metadataReportConfig) {
        this.metadataReportConfig = metadataReportConfig;
    }
}

