/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperDynamicConfiguration.class);
    private Executor executor;
    private String rootPath;
    private final ZookeeperClient zkClient;
    private CountDownLatch initializedLatch;
    private CacheListener cacheListener;
    private URL url;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/config";
        this.initializedLatch = new CountDownLatch(1);
        this.cacheListener = new CacheListener(this.rootPath, this.initializedLatch);
        this.executor = Executors.newFixedThreadPool(1, new NamedThreadFactory(this.getClass().getSimpleName(), true));
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addDataListener(this.rootPath, this.cacheListener, this.executor);
        try {
            this.initializedLatch.await();
        }
        catch (InterruptedException e) {
            logger.warn("Failed to build local cache for config center (zookeeper)." + url);
        }
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.zkClient.getContent(key);
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.addListener(key, listener);
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.removeListener(key, listener);
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isNotEmpty(group)) {
            key = group + "/" + key;
        } else {
            int i = key.lastIndexOf(".");
            key = key.substring(0, i) + "/" + key.substring(i + 1);
        }
        return (String)this.getInternalProperty(this.rootPath + "/" + key);
    }
}

