/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.dubbo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.dubbo.DubboRegistry;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.RouterChain;

public class DubboRegistryFactory
extends AbstractRegistryFactory {
    private Protocol protocol;
    private ProxyFactory proxyFactory;
    private Cluster cluster;

    private static URL getRegistryURL(URL url) {
        return URLBuilder.from(url).setPath(RegistryService.class.getName()).removeParameter("export").removeParameter("refer").addParameter("interface", RegistryService.class.getName()).addParameter("sticky", "true").addParameter("lazy", "true").addParameter("reconnect", "false").addParameterIfAbsent("timeout", "10000").addParameterIfAbsent("callbacks", "10000").addParameterIfAbsent("connect.timeout", "10000").addParameter("methods", StringUtils.join(new HashSet<String>(Arrays.asList(Wrapper.getWrapper(RegistryService.class).getDeclaredMethodNames())), ",")).addParameter("subscribe.1.callback", "true").addParameter("unsubscribe.1.callback", "false").build();
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Registry createRegistry(URL url) {
        url = DubboRegistryFactory.getRegistryURL(url);
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url.removeParameter("backup"));
        String backup = url.getParameter("backup");
        if (backup != null && backup.length() > 0) {
            String[] addresses;
            for (String address : addresses = Constants.COMMA_SPLIT_PATTERN.split(backup)) {
                urls.add(url.setAddress(address));
            }
        }
        RegistryDirectory<RegistryService> directory = new RegistryDirectory<RegistryService>(RegistryService.class, url.addParameter("interface", RegistryService.class.getName()).addParameterAndEncoded("refer", url.toParameterString()));
        Invoker<RegistryService> registryInvoker = this.cluster.join(directory);
        RegistryService registryService = this.proxyFactory.getProxy(registryInvoker);
        DubboRegistry registry = new DubboRegistry(registryInvoker, registryService);
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        directory.setRouterChain(RouterChain.buildChain(url));
        directory.notify(urls);
        directory.subscribe(new URL("consumer", NetUtils.getLocalHost(), 0, RegistryService.class.getName(), url.getParameters()));
        return registry;
    }
}

