/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.curator;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;
import org.apache.dubbo.remoting.zookeeper.support.AbstractZookeeperClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;

public class CuratorZookeeperClient
extends AbstractZookeeperClient<CuratorWatcherImpl, CuratorWatcherImpl> {
    static final Charset charset = Charset.forName("UTF-8");
    private final CuratorFramework client;
    private Map<String, TreeCache> treeCacheMap = new ConcurrentHashMap<String, TreeCache>();

    public CuratorZookeeperClient(URL url) {
        super(url);
        try {
            int timeout = url.getParameter("timeout", 5000);
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url.getBackupAddress()).retryPolicy((RetryPolicy)new RetryNTimes(1, 1000)).connectionTimeoutMs(timeout);
            String authority = url.getAuthority();
            if (authority != null && authority.length() > 0) {
                builder = builder.authorization("digest", authority.getBytes());
            }
            this.client = builder.build();
            this.client.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

                public void stateChanged(CuratorFramework client, ConnectionState state) {
                    if (state == ConnectionState.LOST) {
                        CuratorZookeeperClient.this.stateChanged(0);
                    } else if (state == ConnectionState.CONNECTED) {
                        CuratorZookeeperClient.this.stateChanged(1);
                    } else if (state == ConnectionState.RECONNECTED) {
                        CuratorZookeeperClient.this.stateChanged(2);
                    }
                }
            });
            this.client.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createPersistent(String path) {
        try {
            this.client.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createEphemeral(String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createPersistent(String path, String data) {
        byte[] dataBytes = data.getBytes(charset);
        try {
            this.client.create().forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.client.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createEphemeral(String path, String data) {
        byte[] dataBytes = data.getBytes(charset);
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.client.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void delete(String path) {
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkExists(String path) {
        try {
            if (this.client.checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    @Override
    public String doGetContent(String path) {
        try {
            byte[] dataBytes = (byte[])this.client.getData().forPath(path);
            return dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, charset);
        }
        catch (KeeperException.NoNodeException dataBytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void doClose() {
        this.client.close();
    }

    @Override
    public CuratorWatcherImpl createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(this.client, listener);
    }

    @Override
    public List<String> addTargetChildListener(String path, CuratorWatcherImpl listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected CuratorWatcherImpl createTargetDataListener(String path, DataListener listener) {
        return new CuratorWatcherImpl(this.client, listener);
    }

    @Override
    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        this.addTargetDataListener(path, treeCacheListener, (Executor)null);
    }

    @Override
    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener, Executor executor) {
        try {
            TreeCache treeCache = TreeCache.newBuilder((CuratorFramework)this.client, (String)path).setCacheData(false).build();
            this.treeCacheMap.putIfAbsent(path, treeCache);
            treeCache.start();
            if (executor == null) {
                treeCache.getListenable().addListener((Object)treeCacheListener);
            } else {
                treeCache.getListenable().addListener((Object)treeCacheListener, executor);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Add treeCache listener for path:" + path, e);
        }
    }

    @Override
    protected void removeTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        TreeCache treeCache = this.treeCacheMap.get(path);
        if (treeCache != null) {
            treeCache.getListenable().removeListener((Object)treeCacheListener);
        }
        treeCacheListener.dataListener = null;
    }

    @Override
    public void removeTargetChildListener(String path, CuratorWatcherImpl listener) {
        listener.unwatch();
    }

    CuratorFramework getClient() {
        return this.client;
    }

    static class CuratorWatcherImpl
    implements CuratorWatcher,
    TreeCacheListener {
        private CuratorFramework client;
        private volatile ChildListener childListener;
        private volatile DataListener dataListener;

        public CuratorWatcherImpl(CuratorFramework client, ChildListener listener) {
            this.client = client;
            this.childListener = listener;
        }

        public CuratorWatcherImpl(CuratorFramework client, DataListener dataListener) {
            this.dataListener = dataListener;
        }

        protected CuratorWatcherImpl() {
        }

        public void unwatch() {
            this.childListener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            if (this.childListener != null) {
                String path = event.getPath() == null ? "" : event.getPath();
                this.childListener.childChanged(path, StringUtils.isNotEmpty(path) ? (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(path) : Collections.emptyList());
            }
        }

        public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
            if (this.dataListener != null) {
                TreeCacheEvent.Type type = event.getType();
                EventType eventType = null;
                String content = null;
                String path = null;
                switch (type) {
                    case NODE_ADDED: {
                        eventType = EventType.NodeCreated;
                        path = event.getData().getPath();
                        content = new String(event.getData().getData(), charset);
                        break;
                    }
                    case NODE_UPDATED: {
                        eventType = EventType.NodeDataChanged;
                        path = event.getData().getPath();
                        content = new String(event.getData().getData(), charset);
                        break;
                    }
                    case NODE_REMOVED: {
                        path = event.getData().getPath();
                        eventType = EventType.NodeDeleted;
                        break;
                    }
                    case INITIALIZED: {
                        eventType = EventType.INITIALIZED;
                        break;
                    }
                    case CONNECTION_LOST: {
                        eventType = EventType.CONNECTION_LOST;
                        break;
                    }
                    case CONNECTION_RECONNECTED: {
                        eventType = EventType.CONNECTION_RECONNECTED;
                        break;
                    }
                    case CONNECTION_SUSPENDED: {
                        eventType = EventType.CONNECTION_SUSPENDED;
                    }
                }
                this.dataListener.dataChanged(path, content, eventType);
            }
        }
    }
}

