/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.rest.DubboResourceFactory;
import org.apache.dubbo.rpc.protocol.rest.RestServer;
import org.apache.dubbo.rpc.protocol.rest.RpcContextFilter;
import org.apache.dubbo.rpc.protocol.rest.RpcExceptionMapper;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;

public abstract class BaseRestServer
implements RestServer {
    @Override
    public void start(URL url) {
        this.getDeployment().getMediaTypeMappings().put("json", "application/json");
        this.getDeployment().getMediaTypeMappings().put("xml", "text/xml");
        this.getDeployment().getProviderClasses().add(RpcContextFilter.class.getName());
        this.getDeployment().getProviderClasses().add(RpcExceptionMapper.class.getName());
        this.loadProviders(url.getParameter("extension", ""));
        this.doStart(url);
    }

    @Override
    public void deploy(Class resourceDef, Object resourceInstance, String contextPath) {
        if (StringUtils.isEmpty(contextPath)) {
            this.getDeployment().getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef));
        } else {
            this.getDeployment().getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef), contextPath);
        }
    }

    @Override
    public void undeploy(Class resourceDef) {
        this.getDeployment().getRegistry().removeRegistrations(resourceDef);
    }

    protected void loadProviders(String value) {
        for (String clazz : Constants.COMMA_SPLIT_PATTERN.split(value)) {
            if (StringUtils.isEmpty(clazz)) continue;
            this.getDeployment().getProviderClasses().add(clazz.trim());
        }
    }

    protected abstract ResteasyDeployment getDeployment();

    protected abstract void doStart(URL var1);
}

