/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.etcd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.remoting.etcd.ChildListener;
import org.apache.dubbo.remoting.etcd.EtcdClient;
import org.apache.dubbo.remoting.etcd.EtcdTransporter;
import org.apache.dubbo.remoting.etcd.option.OptionUtil;
import org.apache.dubbo.rpc.RpcException;

public class EtcdRegistry
extends FailbackRegistry {
    private static final int DEFAULT_ETCD_PORT = 2379;
    private static final String DEFAULT_ROOT = "dubbo";
    private final String root;
    private final Set<String> anyServices = new ConcurrentHashSet<String>();
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, ChildListener>> etcdListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, ChildListener>>();
    private final EtcdClient etcdClient;

    public EtcdRegistry(URL url, EtcdTransporter etcdTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address is invalid, actual: '" + url.getHost() + "'");
        }
        String group = url.getParameter("group", DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.etcdClient = etcdTransporter.connect(url);
        this.etcdClient.addStateListener(state -> {
            if (state == 1) {
                try {
                    this.recover();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        });
    }

    protected static String appendDefaultPort(String address) {
        if (address != null && address.length() > 0) {
            int i = address.indexOf(58);
            if (i < 0) {
                return address + ":" + 2379;
            }
            if (Integer.parseInt(address.substring(i + 1)) == 0) {
                return address.substring(0, i + 1) + 2379;
            }
        }
        return address;
    }

    @Override
    public void doRegister(URL url) {
        try {
            String path = this.toUrlPath(url);
            if (url.getParameter("dynamic", true)) {
                this.etcdClient.createEphemeral(path);
                return;
            }
            this.etcdClient.create(path);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + url + " to etcd " + this.getUrl() + ", cause: " + (OptionUtil.isProtocolError(e) ? "etcd3 registry may not be supported yet or etcd3 registry is not available." : e.getMessage()), e);
        }
    }

    @Override
    public void doUnregister(URL url) {
        try {
            String path = this.toUrlPath(url);
            this.etcdClient.delete(path);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to unregister " + url + " to etcd " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        try {
            if ("*".equals(url.getServiceInterface())) {
                String root = this.toRootPath();
                ConcurrentMap listeners = Optional.ofNullable((ConcurrentMap)this.etcdListeners.get(url)).orElseGet(() -> {
                    ConcurrentHashMap container = new ConcurrentHashMap();
                    ConcurrentHashMap prev = this.etcdListeners.putIfAbsent(url, container);
                    return prev != null ? prev : container;
                });
                ChildListener interfaceListener = Optional.ofNullable((ChildListener)listeners.get(listener)).orElseGet(() -> {
                    ChildListener childListener = (parentPath, currentChildren) -> {
                        for (String child : currentChildren) {
                            if (this.anyServices.contains(child = URL.decode(child))) continue;
                            this.anyServices.add(child);
                            this.subscribe(url.setPath(child).addParameters("interface", child, "check", String.valueOf(false)), listener);
                        }
                    };
                    ChildListener prev = listeners.putIfAbsent(listener, childListener);
                    return prev != null ? prev : childListener;
                });
                this.etcdClient.create(root);
                List<String> services = this.etcdClient.addChildListener(root, interfaceListener);
                for (String service : services) {
                    service = URL.decode(service);
                    this.anyServices.add(service);
                    this.subscribe(url.setPath(service).addParameters("interface", service, "check", String.valueOf(false)), listener);
                }
            } else {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : this.toCategoriesPath(url)) {
                    ConcurrentMap listeners = Optional.ofNullable((ConcurrentMap)this.etcdListeners.get(url)).orElseGet(() -> {
                        ConcurrentHashMap container = new ConcurrentHashMap();
                        ConcurrentHashMap prev = this.etcdListeners.putIfAbsent(url, container);
                        return prev != null ? prev : container;
                    });
                    ChildListener childListener = Optional.ofNullable((ChildListener)listeners.get(listener)).orElseGet(() -> {
                        ChildListener watchListener = (parentPath, currentChildren) -> this.notify(url, listener, this.toUrlsWithEmpty(url, parentPath, currentChildren));
                        ChildListener prev = listeners.putIfAbsent(listener, watchListener);
                        return prev != null ? prev : watchListener;
                    });
                    this.etcdClient.create(path);
                    List<String> children = this.etcdClient.addChildListener(path, childListener);
                    if (children == null) continue;
                    urls.addAll(this.toUrlsWithEmpty(url, path, children));
                }
                this.notify(url, listener, urls);
            }
        }
        catch (Throwable e) {
            throw new RpcException("Failed to subscribe " + url + " to etcd " + this.getUrl() + ", cause: " + (OptionUtil.isProtocolError(e) ? "etcd3 registry may not be supported yet or etcd3 registry is not available." : e.getMessage()), e);
        }
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        ConcurrentMap listeners = (ConcurrentMap)this.etcdListeners.get(url);
        if (listeners != null) {
            ChildListener etcdListener = (ChildListener)listeners.remove(listener);
            if (etcdListener != null) {
                if ("*".equals(url.getServiceInterface())) {
                    String root = this.toRootPath();
                    this.etcdClient.removeChildListener(root, etcdListener);
                } else {
                    for (String path : this.toUnsubscribedPath(url)) {
                        this.etcdClient.removeChildListener(path, etcdListener);
                    }
                }
            }
            if (listeners.isEmpty()) {
                this.etcdListeners.remove(url);
            }
        }
    }

    @Override
    public boolean isAvailable() {
        return this.etcdClient.isConnected();
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.etcdClient.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed to close etcd client " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    protected String toRootDir() {
        if (this.root.startsWith("/")) {
            return this.root;
        }
        return "/" + this.root;
    }

    protected String toRootPath() {
        return this.root;
    }

    protected String toServicePath(URL url) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return this.toRootPath();
        }
        return this.toRootDir() + "/" + URL.encode(name);
    }

    protected String[] toCategoriesPath(URL url) {
        String[] categories = "*".equals(url.getParameter("category")) ? new String[]{"providers", "consumers", "routers", "configurators"} : url.getParameter("category", new String[]{"providers"});
        String[] paths = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            paths[i] = this.toServicePath(url) + "/" + categories[i];
        }
        return paths;
    }

    protected String toCategoryPath(URL url) {
        return this.toServicePath(url) + "/" + url.getParameter("category", "providers");
    }

    protected String toUrlPath(URL url) {
        return this.toCategoryPath(url) + "/" + URL.encode(url.toFullString());
    }

    protected List<String> toUnsubscribedPath(URL url) {
        ArrayList<String> categories = new ArrayList<String>();
        if ("*".equals(url.getServiceInterface())) {
            String group = url.getParameter("group", DEFAULT_ROOT);
            if (!group.startsWith("/")) {
                group = "/" + group;
            }
            categories.add(group);
            return categories;
        }
        categories.addAll(Arrays.asList(this.toCategoriesPath(url)));
        return categories;
    }

    protected List<URL> toUrlsWithoutEmpty(URL consumer, List<String> providers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (providers != null && providers.size() > 0) {
            for (String provider : providers) {
                URL url;
                if (!(provider = URL.decode(provider)).contains("://") || !UrlUtils.isMatch(consumer, url = URL.valueOf(provider))) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    protected List<URL> toUrlsWithEmpty(URL consumer, String path, List<String> providers) {
        List<URL> urls = this.toUrlsWithoutEmpty(consumer, providers);
        if (CollectionUtils.isEmpty(urls)) {
            int i = path.lastIndexOf(47);
            String category = i < 0 ? path : path.substring(i + 1);
            URL empty = consumer.setProtocol("empty").addParameter("category", category);
            urls.add(empty);
        }
        return urls;
    }
}

