/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc;

import io.grpc.CallOptions;
import io.grpc.ManagedChannel;
import io.grpc.ServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ClientInterceptor;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.GrpcConfigurator;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ServerInterceptor;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ServerTransportFilter;

public class GrpcOptionsUtils {
    static ServerBuilder buildServerBuilder(URL url, NettyServerBuilder builder) {
        int maxCalls;
        int flowControlWindow;
        int maxInboundMetadataSize;
        int maxInboundMessageSize = url.getParameter("grpc.maxInboundMessageSize", 0);
        if (maxInboundMessageSize > 0) {
            builder.maxInboundMessageSize(maxInboundMessageSize);
        }
        if ((maxInboundMetadataSize = url.getParameter("grpc.maxOutboundMessageSize", 0)) > 0) {
            builder.maxInboundMetadataSize(maxInboundMetadataSize);
        }
        if (url.getParameter("ssl-enabled", false)) {
            builder.sslContext(GrpcOptionsUtils.buildServerSslContext(url));
        }
        if ((flowControlWindow = url.getParameter("grpc.maxInboundMessageSize", 0)) > 0) {
            builder.flowControlWindow(flowControlWindow);
        }
        if ((maxCalls = url.getParameter("grpc.maxConcurrentCallsPerConnection", url.getParameter("executes", 0))) > 0) {
            builder.maxConcurrentCallsPerConnection(maxCalls);
        }
        List<ServerInterceptor> serverInterceptors = ExtensionLoader.getExtensionLoader(ServerInterceptor.class).getActivateExtension(url, "grpc.serverInterceptors", "provider");
        for (ServerInterceptor serverInterceptor : serverInterceptors) {
            builder.intercept((io.grpc.ServerInterceptor)serverInterceptor);
        }
        List<ServerTransportFilter> transportFilters = ExtensionLoader.getExtensionLoader(ServerTransportFilter.class).getActivateExtension(url, "grpc.transportFilters", "provider");
        for (ServerTransportFilter transportFilter : transportFilters) {
            builder.addTransportFilter(transportFilter.grpcTransportFilter());
        }
        String string = url.getParameter("grpc.executor", url.getParameter("dispatcher"));
        if ("direct".equals(string)) {
            builder.directExecutor();
        } else {
            builder.executor(ExtensionLoader.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url));
        }
        return (ServerBuilder)GrpcOptionsUtils.getConfigurator().map(configurator -> configurator.configureServerBuilder(builder, url)).orElse(builder);
    }

    static ManagedChannel buildManagedChannel(URL url) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort());
        if (url.getParameter("ssl-enabled", false)) {
            builder.sslContext(GrpcOptionsUtils.buildClientSslContext(url));
        } else {
            builder.usePlaintext();
        }
        builder.disableRetry();
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>(ExtensionLoader.getExtensionLoader(ClientInterceptor.class).getActivateExtension(url, "grpc.clientInterceptors", "consumer"));
        builder.intercept(interceptors);
        return GrpcOptionsUtils.getConfigurator().map(configurator -> configurator.configureChannelBuilder(builder, url)).orElse(builder).build();
    }

    static CallOptions buildCallOptions(URL url) {
        CallOptions callOptions = CallOptions.DEFAULT;
        return GrpcOptionsUtils.getConfigurator().map(configurator -> configurator.configureCallOptions(callOptions, url)).orElse(callOptions);
    }

    private static SslContext buildServerSslContext(URL url) {
        ConfigManager globalConfigManager = ApplicationModel.getConfigManager();
        SslConfig sslConfig = globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder sslClientContextBuilder = null;
        try {
            String password = sslConfig.getServerKeyPassword();
            sslClientContextBuilder = password != null ? GrpcSslContexts.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream(), (String)password) : GrpcSslContexts.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream());
            InputStream trustCertCollectionFilePath = sslConfig.getServerTrustCertCollectionPathStream();
            if (trustCertCollectionFilePath != null) {
                sslClientContextBuilder.trustManager(trustCertCollectionFilePath);
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", e);
        }
        try {
            return sslClientContextBuilder.build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    private static SslContext buildClientSslContext(URL url) {
        ConfigManager globalConfigManager = ApplicationModel.getConfigManager();
        SslConfig sslConfig = globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder builder = GrpcSslContexts.forClient();
        try {
            InputStream trustCertCollectionFilePath = sslConfig.getClientTrustCertCollectionPathStream();
            if (trustCertCollectionFilePath != null) {
                builder.trustManager(trustCertCollectionFilePath);
            }
            InputStream clientCertChainFilePath = sslConfig.getClientKeyCertChainPathStream();
            InputStream clientPrivateKeyFilePath = sslConfig.getClientPrivateKeyPathStream();
            if (clientCertChainFilePath != null && clientPrivateKeyFilePath != null) {
                String password = sslConfig.getClientKeyPassword();
                if (password != null) {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath, password);
                } else {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find certificate file or find invalid certificate.", e);
        }
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    private static Optional<GrpcConfigurator> getConfigurator() {
        Set<GrpcConfigurator> configurators = ExtensionLoader.getExtensionLoader(GrpcConfigurator.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty(configurators)) {
            return Optional.of(configurators.iterator().next());
        }
        return Optional.empty();
    }
}

