/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.common.base.Strings;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.ThrowablePB;

public class ProtobufWrappedException
extends RuntimeException {
    private static final long serialVersionUID = -1792808536714102039L;
    private String originalClassName;
    private String originalMessage;

    public ProtobufWrappedException(ThrowablePB.ThrowableProto throwableProto) {
        super(throwableProto.getOriginalClassName() + ": " + throwableProto.getOriginalMessage());
        this.originalClassName = throwableProto.getOriginalClassName();
        this.originalMessage = throwableProto.getOriginalMessage();
        if (throwableProto.getStackTraceCount() > 0) {
            this.setStackTrace((StackTraceElement[])throwableProto.getStackTraceList().stream().map(ProtobufWrappedException::toStackTraceElement).toArray(StackTraceElement[]::new));
        }
        if (throwableProto.hasCause()) {
            this.initCause(new ProtobufWrappedException(throwableProto.getCause()));
        }
    }

    public String getOriginalClassName() {
        return this.originalClassName;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    private static StackTraceElement toStackTraceElement(ThrowablePB.StackTraceElementProto proto) {
        return new StackTraceElement(proto.getClassName(), proto.getMethodName(), Strings.emptyToNull((String)proto.getFileName()), proto.getLineNumber());
    }
}

