/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryDestroyedEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryDestroyingEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryExceptionEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryInitializedEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryInitializingEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancePreRegisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancePreUnregisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstanceRegisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstanceUnregisteredEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

final class EventPublishingServiceDiscovery
implements ServiceDiscovery {
    protected static final String REGISTER_ACTION = "register";
    protected static final String UPDATE_ACTION = "update";
    protected static final String UNREGISTER_ACTION = "unregister";
    protected static final String INITIALIZE_ACTION = "initialize";
    protected static final String DESTROY_ACTION = "destroy";
    protected final EventDispatcher eventDispatcher = EventDispatcher.getDefaultExtension();
    protected final AtomicBoolean initialized = new AtomicBoolean(false);
    protected final AtomicBoolean destroyed = new AtomicBoolean(false);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;

    protected EventPublishingServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        if (serviceDiscovery == null) {
            throw new NullPointerException("The ServiceDiscovery argument must not be null!");
        }
        this.serviceDiscovery = serviceDiscovery;
    }

    @Override
    public final void register(ServiceInstance serviceInstance) throws RuntimeException {
        this.assertDestroyed(REGISTER_ACTION);
        this.assertInitialized(REGISTER_ACTION);
        this.executeWithEvents(Optional.of(new ServiceInstancePreRegisteredEvent(this.serviceDiscovery, serviceInstance)), () -> this.serviceDiscovery.register(serviceInstance), Optional.of(new ServiceInstanceRegisteredEvent(this.serviceDiscovery, serviceInstance)));
    }

    @Override
    public final void update(ServiceInstance serviceInstance) throws RuntimeException {
        this.assertDestroyed(UPDATE_ACTION);
        this.assertInitialized(UPDATE_ACTION);
        this.executeWithEvents(Optional.empty(), () -> this.serviceDiscovery.update(serviceInstance), Optional.empty());
    }

    @Override
    public final void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.assertDestroyed(UNREGISTER_ACTION);
        this.assertInitialized(UNREGISTER_ACTION);
        this.executeWithEvents(Optional.of(new ServiceInstancePreUnregisteredEvent(this, serviceInstance)), () -> this.serviceDiscovery.unregister(serviceInstance), Optional.of(new ServiceInstanceUnregisteredEvent(this, serviceInstance)));
    }

    @Override
    public Set<String> getServices() {
        return this.serviceDiscovery.getServices();
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return this.serviceDiscovery.getInstances(serviceName);
    }

    @Override
    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize) throws NullPointerException, IllegalArgumentException {
        return this.serviceDiscovery.getInstances(serviceName, offset, pageSize);
    }

    @Override
    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) throws NullPointerException, IllegalArgumentException {
        return this.serviceDiscovery.getInstances(serviceName, offset, pageSize, healthyOnly);
    }

    @Override
    public Map<String, Page<ServiceInstance>> getInstances(Iterable<String> serviceNames, int offset, int requestSize) throws NullPointerException, IllegalArgumentException {
        return this.serviceDiscovery.getInstances(serviceNames, offset, requestSize);
    }

    @Override
    public String toString() {
        return this.serviceDiscovery.toString();
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        this.serviceDiscovery.addServiceInstancesChangedListener(listener);
        this.eventDispatcher.addEventListener(listener);
    }

    @Override
    public URL getUrl() {
        return this.serviceDiscovery.getUrl();
    }

    @Override
    public ServiceInstance getLocalInstance() {
        return this.serviceDiscovery.getLocalInstance();
    }

    @Override
    public void initialize(URL registryURL) {
        this.assertDestroyed(INITIALIZE_ACTION);
        if (this.isInitialized()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("It's ignored to start current ServiceDiscovery, because it has been started.");
            }
            return;
        }
        this.executeWithEvents(Optional.of(new ServiceDiscoveryInitializingEvent(this, this.serviceDiscovery)), () -> this.serviceDiscovery.initialize(registryURL), Optional.of(new ServiceDiscoveryInitializedEvent(this, this.serviceDiscovery)));
        this.initialized.compareAndSet(false, true);
    }

    @Override
    public void destroy() {
        this.assertDestroyed(DESTROY_ACTION);
        if (this.isDestroyed()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("It's ignored to stop current ServiceDiscovery, because it has been stopped.");
            }
            return;
        }
        this.executeWithEvents(Optional.of(new ServiceDiscoveryDestroyingEvent(this, this.serviceDiscovery)), this.serviceDiscovery::destroy, Optional.of(new ServiceDiscoveryDestroyedEvent(this, this.serviceDiscovery)));
        this.destroyed.compareAndSet(false, true);
    }

    protected final void executeWithEvents(Optional<? extends Event> beforeEvent, ThrowableAction action, Optional<? extends Event> afterEvent) {
        beforeEvent.ifPresent(this::dispatchEvent);
        try {
            action.execute();
        }
        catch (Throwable e) {
            this.logger.error("Execute action throws and dispatch a ServiceDiscoveryExceptionEvent.", e);
            this.dispatchEvent(new ServiceDiscoveryExceptionEvent(this, this.serviceDiscovery, e));
        }
        afterEvent.ifPresent(this::dispatchEvent);
    }

    private void dispatchEvent(Event event) {
        this.eventDispatcher.dispatch(event);
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public final boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected void assertDestroyed(String action) throws IllegalStateException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("The action[" + action + "] is rejected, because the ServiceDiscovery is destroyed already.");
        }
    }

    protected void assertInitialized(String action) throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("The action[" + action + "] is rejected, because the ServiceDiscovery is not initialized yet.");
        }
    }
}

