/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc;

import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class DubboHandlerRegistry
extends HandlerRegistry {
    private final Map<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();
    private final Map<String, ServerMethodDefinition<?, ?>> methods = new ConcurrentHashMap();

    public List<ServerServiceDefinition> getServices() {
        return Collections.unmodifiableList(new ArrayList<ServerServiceDefinition>(this.services.values()));
    }

    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        return this.methods.get(methodName);
    }

    void addService(BindableService bindableService, String key) {
        ServerServiceDefinition service = bindableService.bindService();
        this.services.put(key, service);
        for (ServerMethodDefinition method : service.getMethods()) {
            this.methods.put(method.getMethodDescriptor().getFullMethodName(), method);
        }
    }

    void removeService(String serviceKey) {
        ServerServiceDefinition service = this.services.remove(serviceKey);
        if (null != service) {
            for (ServerMethodDefinition method : service.getMethods()) {
                this.methods.remove(method.getMethodDescriptor().getFullMethodName(), method);
            }
        }
    }
}

