/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.nativethrift;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 40880;
    public static final String NAME = "native-thrift";
    public static final String THRIFT_IFACE = "$Iface";
    public static final String THRIFT_PROCESSOR = "$Processor";
    public static final String THRIFT_CLIENT = "$Client";
    private static final Map<String, TServer> SERVER_MAP = new HashMap<String, TServer>();
    private TMultiplexedProcessor processor = new TMultiplexedProcessor();

    public ThriftProtocol() {
        super(TException.class, RpcException.class);
    }

    public ThriftProtocol(Class<?> ... exceptions) {
        super(exceptions);
    }

    @Override
    public int getDefaultPort() {
        return 40880;
    }

    @Override
    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        return this.exportThreadedSelectorServer(impl, type, url);
    }

    @Override
    protected <T> T doRefer(Class<T> type, URL url) throws RpcException {
        return this.doReferFrameAndCompact(type, url);
    }

    private <T> Runnable exportThreadedSelectorServer(T impl, Class<T> type, URL url) throws RpcException {
        TServer thriftServer = this.getTServer(impl, type, url);
        if (thriftServer == null) {
            return null;
        }
        SERVER_MAP.put(url.getAddress(), thriftServer);
        new Thread(() -> {
            this.logger.info("Start Thrift ThreadedSelectorServer");
            thriftServer.serve();
            this.logger.info("Thrift ThreadedSelectorServer started.");
        }).start();
        return () -> {
            try {
                this.logger.info("Close Thrift NonblockingServer");
                thriftServer.stop();
            }
            catch (Throwable e) {
                this.logger.warn(e.getMessage(), e);
            }
        };
    }

    private <T> T doReferFrameAndCompact(Class<T> type, URL url) throws RpcException {
        try {
            T thriftClient = null;
            String typeName = type.getName();
            if (typeName.endsWith(THRIFT_IFACE)) {
                String clientClsName = typeName.substring(0, typeName.indexOf(THRIFT_IFACE)) + THRIFT_CLIENT;
                Class<?> clazz = Class.forName(clientClsName);
                Constructor<?> constructor = clazz.getConstructor(TProtocol.class);
                try {
                    TSocket tSocket = new TSocket(url.getHost(), url.getPort());
                    TFramedTransport transport = new TFramedTransport((TTransport)tSocket);
                    TCompactProtocol tprotocol = new TCompactProtocol((TTransport)transport);
                    TMultiplexedProtocol protocol = new TMultiplexedProtocol((TProtocol)tprotocol, typeName);
                    thriftClient = (T)constructor.newInstance(protocol);
                    transport.open();
                    this.logger.info("nativethrift client opened for service(" + url + ")");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                    throw new RpcException("Fail to create remote client:" + e.getMessage(), (Throwable)e);
                }
            }
            return thriftClient;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new RpcException("Fail to create remote client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> TServer getTServer(T impl, Class<T> type, URL url) {
        TThreadedSelectorServer tserver;
        TThreadedSelectorServer.Args tArgs = null;
        String typeName = type.getName();
        if (typeName.endsWith(THRIFT_IFACE)) {
            String processorClsName = typeName.substring(0, typeName.indexOf(THRIFT_IFACE)) + THRIFT_PROCESSOR;
            try {
                String bindIp;
                TNonblockingServerSocket.NonblockingAbstractServerSocketArgs args;
                Class<?> clazz = Class.forName(processorClsName);
                Constructor<?> constructor = clazz.getConstructor(type);
                TProcessor tprocessor = (TProcessor)constructor.newInstance(impl);
                this.processor.registerProcessor(typeName, tprocessor);
                tserver = SERVER_MAP.get(url.getAddress());
                if (tserver == null) {
                    args = new TNonblockingServerSocket.NonblockingAbstractServerSocketArgs();
                    args.backlog(1000);
                    bindIp = url.getParameter("bind.ip", url.getHost());
                    if (url.getParameter("anyhost", false)) {
                        bindIp = "0.0.0.0";
                    }
                } else {
                    return null;
                }
                int bindPort = url.getParameter("bind.port", url.getPort());
                args.bindAddr(new InetSocketAddress(bindIp, bindPort));
                args.clientTimeout(10000);
                TNonblockingServerSocket transport = new TNonblockingServerSocket(args);
                tArgs = new TThreadedSelectorServer.Args((TNonblockingServerTransport)transport);
                tArgs.workerThreads(200);
                tArgs.selectorThreads(4);
                tArgs.acceptQueueSizePerThread(256);
                tArgs.processor((TProcessor)this.processor);
                tArgs.transportFactory((TTransportFactory)new TFramedTransport.Factory());
                tArgs.protocolFactory((TProtocolFactory)new TCompactProtocol.Factory());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                throw new RpcException("Fail to create nativethrift server(" + url + ") : " + e.getMessage(), (Throwable)e);
            }
        }
        if (tArgs == null) {
            this.logger.error("Fail to create native thrift server(" + url + ") due to null args");
            throw new RpcException("Fail to create nativethrift server(" + url + ") due to null args");
        }
        tserver = new TThreadedSelectorServer(tArgs);
        return tserver;
    }
}

