/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.xml.rpc.protocol.xmlrpc;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.dubbo.rpc.RpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class XmlRpcProxyFactoryBean
extends UrlBasedRemoteAccessor
implements MethodInterceptor,
InitializingBean,
FactoryBean<Object>,
ApplicationContextAware {
    private Object proxyObject = null;
    private XmlRpcClient xmlRpcClient = null;
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.proxyObject = ProxyFactory.getProxy((Class)this.getServiceInterface(), (Interceptor)this);
        try {
            this.xmlRpcClient = new XmlRpcClient();
            XmlRpcClientConfigImpl xmlRpcClientConfig = new XmlRpcClientConfigImpl();
            xmlRpcClientConfig.setServerURL(new URL(this.getServiceUrl()));
            this.xmlRpcClient.setConfig((XmlRpcClientConfig)xmlRpcClientConfig);
        }
        catch (MalformedURLException mue) {
            throw new RpcException(mue);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method.getDeclaringClass() == Object.class && "toString".equals(method.getName())) {
            return this.proxyObject.getClass().getName() + "@" + System.identityHashCode(this.proxyObject);
        }
        Class<?> retType = invocation.getMethod().getGenericReturnType() != null ? invocation.getMethod().getGenericReturnType() : invocation.getMethod().getReturnType();
        return this.xmlRpcClient.execute(XmlRpcProxyFactoryBean.replace(method.getDeclaringClass().getName()) + "." + invocation.getMethod().getName(), invocation.getArguments());
    }

    public Object getObject() {
        return this.proxyObject;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public static final String replace(String name) {
        return name.replaceAll("\\.", "_");
    }
}

