/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.URLStrParser;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.dubbo.rpc.RpcException;

public class ZookeeperRegistry
extends FailbackRegistry {
    private static final String DEFAULT_ROOT = "dubbo";
    private final String root;
    private final Set<String> anyServices = new ConcurrentHashSet<String>();
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, ChildListener>> zkListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, ChildListener>>();
    private final ZookeeperClient zkClient;

    public ZookeeperRegistry(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addStateListener(state -> {
            if (state == 2) {
                this.logger.warn("Trying to fetch the latest urls, in case there're provider changes during connection loss.\n Since ephemeral ZNode will not get deleted for a connection lose, there's no need to re-register url of this instance.");
                this.fetchLatestAddresses();
            } else if (state == 4) {
                this.logger.warn("Trying to re-register urls and re-subscribe listeners of this instance to registry...");
                try {
                    this.recover();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            } else if (state == 0) {
                this.logger.warn("Url of this instance will be deleted from registry soon. Dubbo client will try to re-register once a new session is created.");
            } else if (state == 3 || state == 1) {
                // empty if block
            }
        });
    }

    @Override
    public boolean isAvailable() {
        return this.zkClient.isConnected();
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.zkClient.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed to close zookeeper client " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doRegister(URL url) {
        try {
            this.zkClient.create(this.toUrlPath(url), url.getParameter("dynamic", true));
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doUnregister(URL url) {
        try {
            this.zkClient.delete(this.toUrlPath(url));
        }
        catch (Throwable e) {
            throw new RpcException("Failed to unregister " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        try {
            if ("*".equals(url.getServiceInterface())) {
                String root = this.toRootPath();
                ConcurrentMap listeners = this.zkListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
                ChildListener zkListener = listeners.computeIfAbsent(listener, k -> (parentPath, currentChilds) -> {
                    for (String child : currentChilds) {
                        if (this.anyServices.contains(child = URL.decode(child))) continue;
                        this.anyServices.add(child);
                        this.subscribe(url.setPath(child).addParameters("interface", child, "check", String.valueOf(false)), (NotifyListener)k);
                    }
                });
                this.zkClient.create(root, false);
                List<String> services = this.zkClient.addChildListener(root, zkListener);
                if (CollectionUtils.isNotEmpty(services)) {
                    for (String service : services) {
                        service = URL.decode(service);
                        this.anyServices.add(service);
                        this.subscribe(url.setPath(service).addParameters("interface", service, "check", String.valueOf(false)), listener);
                    }
                }
            } else {
                CountDownLatch latch = new CountDownLatch(1);
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : this.toCategoriesPath(url)) {
                    ConcurrentMap listeners = this.zkListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
                    ChildListener zkListener = listeners.computeIfAbsent(listener, k -> new RegistryChildListenerImpl(url, (NotifyListener)k, latch));
                    if (zkListener instanceof RegistryChildListenerImpl) {
                        ((RegistryChildListenerImpl)zkListener).setLatch(latch);
                    }
                    this.zkClient.create(path, false);
                    List<String> children = this.zkClient.addChildListener(path, zkListener);
                    if (children == null) continue;
                    urls.addAll(this.toUrlsWithEmpty(url, path, children));
                }
                this.notify(url, listener, urls);
                latch.countDown();
            }
        }
        catch (Throwable e) {
            throw new RpcException("Failed to subscribe " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(url);
        if (listeners != null) {
            ChildListener zkListener = (ChildListener)listeners.remove(listener);
            if (zkListener != null) {
                if ("*".equals(url.getServiceInterface())) {
                    String root = this.toRootPath();
                    this.zkClient.removeChildListener(root, zkListener);
                } else {
                    for (String path : this.toCategoriesPath(url)) {
                        this.zkClient.removeChildListener(path, zkListener);
                    }
                }
            }
            if (listeners.isEmpty()) {
                this.zkListeners.remove(url);
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            ArrayList<String> providers = new ArrayList<String>();
            for (String path : this.toCategoriesPath(url)) {
                List<String> children = this.zkClient.getChildren(path);
                if (children == null) continue;
                providers.addAll(children);
            }
            return this.toUrlsWithoutEmpty(url, providers);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to lookup " + url + " from zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    private String toRootPath() {
        return this.root;
    }

    private String toServicePath(URL url) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return this.toRootPath();
        }
        return this.toRootDir() + URL.encode(name);
    }

    private String[] toCategoriesPath(URL url) {
        String[] categories = "*".equals(url.getParameter("category")) ? new String[]{"providers", "consumers", "routers", "configurators"} : url.getParameter("category", new String[]{"providers"});
        String[] paths = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            paths[i] = this.toServicePath(url) + "/" + categories[i];
        }
        return paths;
    }

    private String toCategoryPath(URL url) {
        return this.toServicePath(url) + "/" + url.getParameter("category", "providers");
    }

    private String toUrlPath(URL url) {
        return this.toCategoryPath(url) + "/" + URL.encode(url.toFullString());
    }

    private List<URL> toUrlsWithoutEmpty(URL consumer, List<String> providers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (CollectionUtils.isNotEmpty(providers)) {
            for (String provider : providers) {
                URL url;
                if (!provider.contains(CommonConstants.PROTOCOL_SEPARATOR_ENCODED) || !UrlUtils.isMatch(consumer, url = URLStrParser.parseEncodedStr(provider))) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private List<URL> toUrlsWithEmpty(URL consumer, String path, List<String> providers) {
        List<URL> urls = this.toUrlsWithoutEmpty(consumer, providers);
        if (CollectionUtils.isEmpty(urls)) {
            int i = path.lastIndexOf("/");
            String category = i < 0 ? path : path.substring(i + 1);
            URL empty = URLBuilder.from(consumer).setProtocol("empty").addParameter("category", category).build();
            urls.add(empty);
        }
        return urls;
    }

    private void fetchLatestAddresses() {
        HashMap<URL, Set<NotifyListener>> recoverSubscribed = new HashMap<URL, Set<NotifyListener>>(this.getSubscribed());
        if (!recoverSubscribed.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Fetching the latest urls of " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.removeFailedSubscribed(url, listener);
                    this.addFailedSubscribed(url, listener);
                }
            }
        }
    }

    private class RegistryChildListenerImpl
    implements ChildListener {
        private URL url;
        private NotifyListener listener;
        private volatile CountDownLatch latch;

        RegistryChildListenerImpl(URL url, NotifyListener listener, CountDownLatch latch) {
            this.url = url;
            this.listener = listener;
            this.latch = latch;
        }

        void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void childChanged(String path, List<String> children) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                ZookeeperRegistry.this.logger.warn("Zookeeper children listener thread was interrupted unexpectedly, may cause race condition with the main thread.");
            }
            ZookeeperRegistry.this.notify(this.url, this.listener, ZookeeperRegistry.this.toUrlsWithEmpty(this.url, path, children));
        }
    }
}

