/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.grizzly;

import java.io.IOException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;
import org.apache.dubbo.remoting.buffer.DynamicChannelBuffer;
import org.apache.dubbo.remoting.transport.grizzly.GrizzlyChannel;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class GrizzlyCodecAdapter
extends BaseFilter {
    private final Codec2 codec;
    private final URL url;
    private final ChannelHandler handler;
    private final int bufferSize;
    private ChannelBuffer previousData = ChannelBuffers.EMPTY_BUFFER;

    public GrizzlyCodecAdapter(Codec2 codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleWrite(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer(1024);
            Object msg = context.getMessage();
            this.codec.encode(channel, channelBuffer, msg);
            GrizzlyChannel.removeChannelIfDisconnected(connection);
            Buffer buffer = connection.getTransport().getMemoryManager().allocate(channelBuffer.readableBytes());
            buffer.put(channelBuffer.toByteBuffer());
            buffer.flip();
            buffer.allowBufferDispose(true);
            context.setMessage((Object)buffer);
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
        return context.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext context) throws IOException {
        Object message = context.getMessage();
        Connection connection = context.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            if (message instanceof Buffer) {
                Object msg;
                ChannelBuffer frame;
                Buffer grizzlyBuffer = (Buffer)message;
                if (this.previousData.readable()) {
                    if (this.previousData instanceof DynamicChannelBuffer) {
                        this.previousData.writeBytes(grizzlyBuffer.toByteBuffer());
                        frame = this.previousData;
                    } else {
                        int size = this.previousData.readableBytes() + grizzlyBuffer.remaining();
                        frame = ChannelBuffers.dynamicBuffer(size > this.bufferSize ? size : this.bufferSize);
                        frame.writeBytes(this.previousData, this.previousData.readableBytes());
                        frame.writeBytes(grizzlyBuffer.toByteBuffer());
                    }
                } else {
                    frame = ChannelBuffers.wrappedBuffer(grizzlyBuffer.toByteBuffer());
                }
                int savedReadIndex = frame.readerIndex();
                try {
                    msg = this.codec.decode(channel, frame);
                }
                catch (Exception e) {
                    this.previousData = ChannelBuffers.EMPTY_BUFFER;
                    throw new IOException(e.getMessage(), e);
                }
                if (msg == Codec2.DecodeResult.NEED_MORE_INPUT) {
                    frame.readerIndex(savedReadIndex);
                    NextAction nextAction = context.getStopAction();
                    return nextAction;
                }
                if (savedReadIndex == frame.readerIndex()) {
                    this.previousData = ChannelBuffers.EMPTY_BUFFER;
                    throw new IOException("Decode without read data.");
                }
                if (msg != null) {
                    context.setMessage(msg);
                }
                NextAction nextAction = context.getInvokeAction();
                return nextAction;
            }
            NextAction nextAction = context.getInvokeAction();
            return nextAction;
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
    }
}

