/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyClientHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;
import org.apache.dubbo.remoting.transport.netty4.SslContexts;

public class SslHandlerInitializer {
    private static final Logger logger = LoggerFactory.getLogger(SslHandlerInitializer.class);

    public static ChannelInboundHandler sslServerHandler(URL url, NettyServerHandler serverHandler) {
        return new SslServerTlsHandler(url, serverHandler);
    }

    public static ChannelInboundHandler sslClientHandler(URL url, NettyClientHandler clientHandler) {
        return new SslClientTlsHandler(url, clientHandler);
    }

    public static class HandshakeCompletionEvent {
        private final SSLSession sslSession;
        private final ChannelHandlerContext ctx;

        public HandshakeCompletionEvent(SSLSession sslSession, ChannelHandlerContext ctx) {
            this.sslSession = sslSession;
            this.ctx = ctx;
        }

        public SSLSession getSslSession() {
            return this.sslSession;
        }

        public ChannelHandlerContext getCtx() {
            return this.ctx;
        }
    }

    public static class SslClientTlsHandler
    extends ChannelInboundHandlerAdapter {
        private final SslContext sslContext;
        private final NettyClientHandler clientHandler;

        public SslClientTlsHandler(URL url, NettyClientHandler clientHandler) {
            this.sslContext = SslContexts.buildClientSslContext(url);
            this.clientHandler = clientHandler;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)new SslHandler(sslEngine, false));
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                    logger.info("TLS negotiation succeed with session: " + session);
                    this.clientHandler.handshakeCompleted(new HandshakeCompletionEvent(session, ctx));
                    ctx.pipeline().remove((ChannelHandler)this);
                } else {
                    logger.error("TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                    ctx.fireExceptionCaught(handshakeEvent.cause());
                }
            }
        }
    }

    public static class SslServerTlsHandler
    extends ChannelInboundHandlerAdapter {
        private final SslContext sslContext;
        private final NettyServerHandler serverHandler;

        SslServerTlsHandler(URL url, NettyServerHandler serverHandler) {
            this.sslContext = SslContexts.buildServerSslContext(url);
            this.serverHandler = serverHandler;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
            ctx.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine, false)});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("TLS negotiation failed when trying to accept new connection.", cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                    logger.info("TLS negotiation succeed with session: " + session);
                    this.serverHandler.handshakeCompleted(new HandshakeCompletionEvent(session, ctx));
                    ctx.pipeline().remove((ChannelHandler)this);
                } else {
                    logger.error("TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                    ctx.close();
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

