/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.rmi.RemoteException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.rmi.RmiRemoteInvocation;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class RmiProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 1099;

    public RmiProtocol() {
        super(RemoteAccessException.class, RemoteException.class);
    }

    @Override
    public int getDefaultPort() {
        return 1099;
    }

    @Override
    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        final RmiServiceExporter rmiServiceExporter = this.createExporter(impl, type, url, false);
        final RmiServiceExporter genericServiceExporter = this.createExporter(impl, GenericService.class, url, true);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    rmiServiceExporter.destroy();
                    genericServiceExporter.destroy();
                }
                catch (Throwable e) {
                    RmiProtocol.this.logger.warn(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        boolean isGeneric;
        RmiProxyFactoryBean rmiProxyFactoryBean = new RmiProxyFactoryBean();
        String generic = url.getParameter("generic");
        boolean bl = isGeneric = ProtocolUtils.isGeneric(generic) || serviceType.equals(GenericService.class);
        if (Version.isRelease270OrHigher(url.getParameter("release"))) {
            rmiProxyFactoryBean.setRemoteInvocationFactory(methodInvocation -> {
                RmiRemoteInvocation invocation = new RmiRemoteInvocation(methodInvocation);
                if (isGeneric) {
                    invocation.addAttribute("generic", (Serializable)((Object)generic));
                }
                return invocation;
            });
        } else if (Version.isRelease263OrHigher(url.getParameter("dubbo"))) {
            rmiProxyFactoryBean.setRemoteInvocationFactory(methodInvocation -> {
                com.alibaba.dubbo.rpc.protocol.rmi.RmiRemoteInvocation invocation = new com.alibaba.dubbo.rpc.protocol.rmi.RmiRemoteInvocation(methodInvocation);
                if (isGeneric) {
                    invocation.addAttribute("generic", (Serializable)((Object)generic));
                }
                return invocation;
            });
        }
        String serviceUrl = url.toIdentityString();
        if (isGeneric) {
            serviceUrl = serviceUrl + "/" + "generic";
        }
        rmiProxyFactoryBean.setServiceUrl(serviceUrl);
        rmiProxyFactoryBean.setServiceInterface(serviceType);
        rmiProxyFactoryBean.setCacheStub(true);
        rmiProxyFactoryBean.setLookupStubOnStartup(true);
        rmiProxyFactoryBean.setRefreshStubOnConnectFailure(true);
        rmiProxyFactoryBean.afterPropertiesSet();
        return (T)rmiProxyFactoryBean.getObject();
    }

    @Override
    protected int getErrorCode(Throwable e) {
        if (e instanceof RemoteAccessException) {
            e = e.getCause();
        }
        if (e != null && e.getCause() != null) {
            Class<?> cls = e.getCause().getClass();
            if (SocketTimeoutException.class.equals(cls)) {
                return 2;
            }
            if (IOException.class.isAssignableFrom(cls)) {
                return 1;
            }
            if (ClassNotFoundException.class.isAssignableFrom(cls)) {
                return 5;
            }
        }
        return super.getErrorCode(e);
    }

    private <T> RmiServiceExporter createExporter(T impl, Class<?> type, URL url, boolean isGeneric) {
        RmiServiceExporter rmiServiceExporter = new RmiServiceExporter();
        rmiServiceExporter.setRegistryPort(url.getPort());
        if (isGeneric) {
            rmiServiceExporter.setServiceName(url.getPath() + "/" + "generic");
        } else {
            rmiServiceExporter.setServiceName(url.getPath());
        }
        rmiServiceExporter.setServiceInterface(type);
        rmiServiceExporter.setService(impl);
        try {
            rmiServiceExporter.afterPropertiesSet();
        }
        catch (RemoteException e) {
            throw new RpcException(e.getMessage(), (Throwable)e);
        }
        return rmiServiceExporter;
    }
}

