/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;

public class CacheListener
implements DataListener {
    private Map<String, Set<ConfigurationListener>> keyListeners = new ConcurrentHashMap<String, Set<ConfigurationListener>>();
    private String rootPath;

    public CacheListener(String rootPath) {
        this.rootPath = rootPath;
    }

    public void addListener(String key, ConfigurationListener configurationListener) {
        Set listeners = this.keyListeners.computeIfAbsent(key, k -> new CopyOnWriteArraySet());
        listeners.add(configurationListener);
    }

    public void removeListener(String key, ConfigurationListener configurationListener) {
        Set<ConfigurationListener> listeners = this.keyListeners.get(key);
        if (listeners != null) {
            listeners.remove(configurationListener);
        }
    }

    public void removeAllListeners() {
        this.keyListeners.clear();
    }

    public Set<ConfigurationListener> getConfigurationListeners(String key) {
        return this.keyListeners.get(key);
    }

    private String pathToKey(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        String groupKey = path.replace(this.rootPath + "/", "").replaceAll("/", ".");
        return groupKey.substring(groupKey.indexOf(".") + 1);
    }

    private String getGroup(String path) {
        String remain;
        int endIndex;
        int beginIndex;
        if (!StringUtils.isEmpty(path) && (beginIndex = path.indexOf(this.rootPath + "/")) > -1 && (endIndex = (remain = path.substring((this.rootPath + "/").length())).lastIndexOf("/")) > -1) {
            return remain.substring(0, endIndex);
        }
        return path;
    }

    @Override
    public void dataChanged(String path, Object value, EventType eventType) {
        ConfigChangeType changeType = EventType.NodeCreated.equals((Object)eventType) ? ConfigChangeType.ADDED : (value == null ? ConfigChangeType.DELETED : ConfigChangeType.MODIFIED);
        String key = this.pathToKey(path);
        ConfigChangedEvent configChangeEvent = new ConfigChangedEvent(key, this.getGroup(path), (String)value, changeType);
        Set<ConfigurationListener> listeners = this.keyListeners.get(path);
        if (CollectionUtils.isNotEmpty(listeners)) {
            listeners.forEach(listener -> listener.process(configChangeEvent));
        }
    }
}

