/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.dubbo.common.beanutil.JavaBeanAccessor;
import org.apache.dubbo.common.beanutil.JavaBeanDescriptor;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"consumer"}, value={"generic"}, order=20000)
public class GenericImplFilter
extends ListenableFilter {
    private static final Logger logger = LoggerFactory.getLogger(GenericImplFilter.class);
    private static final Class<?>[] GENERIC_PARAMETER_TYPES = new Class[]{String.class, String[].class, Object[].class};

    public GenericImplFilter() {
        this.listener = new GenericImplListener();
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String generic = invoker.getUrl().getParameter("generic");
        if (ProtocolUtils.isGeneric(generic) && !"$invoke".equals(invocation.getMethodName()) && !"$invokeAsync".equals(invocation.getMethodName()) && invocation instanceof RpcInvocation) {
            Object[] args;
            RpcInvocation invocation2 = new RpcInvocation(invocation);
            String methodName = invocation2.getMethodName();
            Class<?>[] parameterTypes = invocation2.getParameterTypes();
            Object[] arguments = invocation2.getArguments();
            String[] types = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                types[i] = ReflectUtils.getName(parameterTypes[i]);
            }
            if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                args = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    args[i] = JavaBeanSerializeUtil.serialize(arguments[i], JavaBeanAccessor.METHOD);
                }
            } else {
                args = PojoUtils.generalize(arguments);
            }
            if (RpcUtils.isReturnTypeFuture(invocation)) {
                invocation2.setMethodName("$invokeAsync");
            } else {
                invocation2.setMethodName("$invoke");
            }
            invocation2.setParameterTypes(GENERIC_PARAMETER_TYPES);
            invocation2.setArguments(new Object[]{methodName, types, args});
            return invoker.invoke(invocation2);
        }
        if ((invocation.getMethodName().equals("$invoke") || invocation.getMethodName().equals("$invokeAsync")) && invocation.getArguments() != null && invocation.getArguments().length == 3 && ProtocolUtils.isGeneric(generic)) {
            Object[] args = (Object[])invocation.getArguments()[2];
            if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (byte[].class == arg.getClass()) continue;
                    this.error(generic, byte[].class.getName(), arg.getClass().getName());
                }
            } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (arg instanceof JavaBeanDescriptor) continue;
                    this.error(generic, JavaBeanDescriptor.class.getName(), arg.getClass().getName());
                }
            }
            invocation.setAttachment("generic", invoker.getUrl().getParameter("generic"));
        }
        return invoker.invoke(invocation);
    }

    private void error(String generic, String expected, String actual) throws RpcException {
        throw new RpcException("Generic serialization [" + generic + "] only support message type " + expected + " and your message type is " + actual);
    }

    static class GenericImplListener
    implements Filter.Listener {
        GenericImplListener() {
        }

        @Override
        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            block21: {
                String generic = invoker.getUrl().getParameter("generic");
                String methodName = invocation.getMethodName();
                Class<?>[] parameterTypes = invocation.getParameterTypes();
                if (ProtocolUtils.isGeneric(generic) && !"$invoke".equals(invocation.getMethodName()) && !"$invokeAsync".equals(invocation.getMethodName()) && invocation instanceof RpcInvocation) {
                    if (!appResponse.hasException()) {
                        Object value = appResponse.getValue();
                        try {
                            Method method = invoker.getInterface().getMethod(methodName, parameterTypes);
                            if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                                if (value == null) {
                                    appResponse.setValue(value);
                                }
                                if (value instanceof JavaBeanDescriptor) {
                                    appResponse.setValue(JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)value));
                                }
                                throw new RpcException("The type of result value is " + value.getClass().getName() + " other than " + JavaBeanDescriptor.class.getName() + ", and the result is " + value);
                            }
                            Type[] types = ReflectUtils.getReturnTypes(method);
                            appResponse.setValue(PojoUtils.realize(value, (Class)types[0], types[1]));
                        }
                        catch (NoSuchMethodException e) {
                            throw new RpcException(e.getMessage(), (Throwable)e);
                        }
                    } else if (appResponse.getException() instanceof GenericException) {
                        GenericException exception = (GenericException)appResponse.getException();
                        try {
                            String className = exception.getExceptionClass();
                            Class<?> clazz = ReflectUtils.forName(className);
                            Throwable targetException = null;
                            Throwable lastException = null;
                            try {
                                targetException = (Throwable)clazz.newInstance();
                            }
                            catch (Throwable e) {
                                lastException = e;
                                for (Constructor<?> constructor : clazz.getConstructors()) {
                                    try {
                                        targetException = (Throwable)constructor.newInstance(new Object[constructor.getParameterTypes().length]);
                                        break;
                                    }
                                    catch (Throwable e1) {
                                        lastException = e1;
                                    }
                                }
                            }
                            if (targetException != null) {
                                try {
                                    Field field = Throwable.class.getDeclaredField("detailMessage");
                                    if (!field.isAccessible()) {
                                        field.setAccessible(true);
                                    }
                                    field.set(targetException, exception.getExceptionMessage());
                                }
                                catch (Throwable e) {
                                    logger.warn(e.getMessage(), e);
                                }
                                appResponse.setException(targetException);
                                break block21;
                            }
                            if (lastException != null) {
                                throw lastException;
                            }
                        }
                        catch (Throwable e) {
                            throw new RpcException("Can not deserialize exception " + exception.getExceptionClass() + ", message: " + exception.getExceptionMessage(), e);
                        }
                    }
                }
            }
        }

        @Override
        public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        }
    }
}

