/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.webservice;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.remoting.http.servlet.DispatcherServlet;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;

public class WebServiceProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 80;
    private final Map<String, HttpServer> serverMap = new ConcurrentHashMap<String, HttpServer>();
    private final ExtensionManagerBus bus = new ExtensionManagerBus();
    private final HTTPTransportFactory transportFactory = new HTTPTransportFactory();
    private HttpBinder httpBinder;

    public WebServiceProtocol() {
        super(Fault.class);
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        HttpServer httpServer = this.serverMap.get(addr);
        if (httpServer == null) {
            httpServer = this.httpBinder.bind(url, new WebServiceHandler());
            this.serverMap.put(addr, httpServer);
        }
        final ServerFactoryBean serverFactoryBean = new ServerFactoryBean();
        serverFactoryBean.setAddress(url.getAbsolutePath());
        serverFactoryBean.setServiceClass(type);
        serverFactoryBean.setServiceBean(impl);
        serverFactoryBean.setBus((Bus)this.bus);
        serverFactoryBean.setDestinationFactory((DestinationFactory)this.transportFactory);
        serverFactoryBean.create();
        return new Runnable(){

            @Override
            public void run() {
                if (serverFactoryBean.getServer() != null) {
                    serverFactoryBean.getServer().destroy();
                }
                if (serverFactoryBean.getBus() != null) {
                    serverFactoryBean.getBus().shutdown(true);
                }
            }
        };
    }

    @Override
    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        ClientProxyFactoryBean proxyFactoryBean = new ClientProxyFactoryBean();
        proxyFactoryBean.setAddress(url.setProtocol("http").toIdentityString());
        proxyFactoryBean.setServiceClass(serviceType);
        proxyFactoryBean.setBus((Bus)this.bus);
        Object ref = proxyFactoryBean.create();
        Client proxy = ClientProxy.getClient((Object)ref);
        HTTPConduit conduit = (HTTPConduit)proxy.getConduit();
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setConnectionTimeout((long)url.getParameter("connect.timeout", 3000));
        policy.setReceiveTimeout((long)url.getParameter("timeout", 1000));
        conduit.setClient(policy);
        return (T)ref;
    }

    @Override
    protected int getErrorCode(Throwable e) {
        if (e instanceof Fault) {
            e = e.getCause();
        }
        if (e instanceof SocketTimeoutException) {
            return 2;
        }
        if (e instanceof IOException) {
            return 1;
        }
        return super.getErrorCode(e);
    }

    private class WebServiceHandler
    implements HttpHandler {
        private volatile ServletController servletController;

        private WebServiceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.servletController == null) {
                DispatcherServlet httpServlet = DispatcherServlet.getInstance();
                if (httpServlet == null) {
                    response.sendError(500, "No such DispatcherServlet instance.");
                    return;
                }
                WebServiceHandler webServiceHandler = this;
                synchronized (webServiceHandler) {
                    if (this.servletController == null) {
                        this.servletController = new ServletController(WebServiceProtocol.this.transportFactory.getRegistry(), httpServlet.getServletConfig(), (HttpServlet)httpServlet);
                    }
                }
            }
            RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
            this.servletController.invoke(request, response);
        }
    }
}

