/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.telnet;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.Help;

@Activate
@Help(parameter="[-t <milliseconds>]", summary="Shutdown Dubbo Application.", detail="Shutdown Dubbo Application.")
public class ShutdownTelnetHandler
implements TelnetHandler {
    @Override
    public String telnet(Channel channel, String message) throws RemotingException {
        int sleepMilliseconds = 0;
        if (StringUtils.isNotEmpty(message)) {
            String[] parameters = message.split("\\s+");
            if (parameters.length == 2 && "-t".equals(parameters[0]) && StringUtils.isInteger(parameters[1])) {
                sleepMilliseconds = Integer.parseInt(parameters[1]);
            } else {
                return "Invalid parameter,please input like shutdown -t 10000";
            }
        }
        long start = System.currentTimeMillis();
        if (sleepMilliseconds > 0) {
            try {
                Thread.sleep(sleepMilliseconds);
            }
            catch (InterruptedException e) {
                return "Failed to invoke shutdown command, cause: " + e.getMessage();
            }
        }
        StringBuilder buf = new StringBuilder();
        DubboShutdownHook.getDubboShutdownHook().unregister();
        DubboShutdownHook.getDubboShutdownHook().doDestroy();
        long end = System.currentTimeMillis();
        buf.append("Application has shutdown successfully");
        buf.append("\r\nelapsed: ");
        buf.append(end - start);
        buf.append(" ms.");
        return buf.toString();
    }
}

