/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufUtils;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;

public class GenericProtobufJsonObjectOutput
implements ObjectOutput {
    private final PrintWriter writer;

    public GenericProtobufJsonObjectOutput(OutputStream out) {
        this.writer = new PrintWriter(new OutputStreamWriter(out));
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.writeObject(BoolValue.newBuilder().setValue(v).build());
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue(v).build());
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeObject(Int64Value.newBuilder().setValue(v).build());
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeObject(FloatValue.newBuilder().setValue(v).build());
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeObject(DoubleValue.newBuilder().setValue(v).build());
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.writeObject(StringValue.newBuilder().setValue(v).build());
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b)).build());
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b, (int)off, (int)len)).build());
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            throw new IllegalArgumentException("This serialization only support google protobuf object, the object is : null");
        }
        if (!ProtobufUtils.isSupported(obj.getClass())) {
            throw new IllegalArgumentException("This serialization only support google protobuf object, the object class is: " + obj.getClass().getName());
        }
        this.writer.write(ProtobufUtils.serializeJson(obj));
        this.writer.println();
        this.writer.flush();
    }

    @Override
    public void writeThrowable(Object th) throws IOException {
        if (th instanceof Throwable && !ProtobufUtils.isSupported(th.getClass())) {
            th = ProtobufUtils.convertToThrowableProto((Throwable)th);
        }
        this.writer.write(ProtobufUtils.serializeJson(th));
        this.writer.println();
        this.writer.flush();
    }

    @Override
    public void writeEvent(Object data) throws IOException {
        if (data == CommonConstants.HEARTBEAT_EVENT) {
            data = "H";
        }
        this.writeUTF((String)data);
    }

    @Override
    public void writeAttachments(Map<String, String> attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        MapValue.Map proto = MapValue.Map.newBuilder().putAllAttachments(attachments).build();
        this.writer.write(ProtobufUtils.serializeJson(proto));
        this.writer.println();
        this.writer.flush();
    }

    @Override
    public void flushBuffer() {
        this.writer.flush();
    }
}

