/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceRepository;

@Cmd(name="offline", summary="offline dubbo", example={"offline dubbo", "offline xx.xx.xxx.service"})
public class Offline
implements BaseCommand {
    private Logger logger = LoggerFactory.getLogger(Offline.class);
    private static RegistryFactory registryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
    private static ServiceRepository serviceRepository = ApplicationModel.getServiceRepository();

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        boolean hasService;
        this.logger.info("receive offline command");
        String servicePattern = ".*";
        if (args != null && args.length > 0) {
            servicePattern = args[0];
        }
        if (hasService = Offline.offline(servicePattern)) {
            return "OK";
        }
        return "service not found";
    }

    public static boolean offline(String servicePattern) {
        boolean hasService = false;
        List<ProviderModel> providerModelList = serviceRepository.getExportedServices();
        for (ProviderModel providerModel : providerModelList) {
            if (!providerModel.getServiceKey().matches(servicePattern)) continue;
            hasService = true;
            List<ProviderModel.RegisterStatedURL> statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                if (!statedURL.isRegistered()) continue;
                Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
                registry.unregister(statedURL.getProviderUrl());
                statedURL.setRegistered(false);
            }
        }
        return hasService;
    }
}

