/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.dubbo;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.rpc.Invoker;

public class DubboRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DubboRegistry.class);
    private static final int RECONNECT_PERIOD_DEFAULT = 3000;
    private final ScheduledExecutorService reconnectTimer = Executors.newScheduledThreadPool(1, new NamedThreadFactory("DubboRegistryReconnectTimer", true));
    private final ScheduledFuture<?> reconnectFuture;
    private final ReentrantLock clientLock = new ReentrantLock();
    private final Invoker<RegistryService> registryInvoker;
    private final RegistryService registryService;
    private final int reconnectPeriod;

    public DubboRegistry(Invoker<RegistryService> registryInvoker, RegistryService registryService) {
        super(registryInvoker.getUrl());
        this.registryInvoker = registryInvoker;
        this.registryService = registryService;
        this.reconnectPeriod = registryInvoker.getUrl().getParameter("reconnect.period", 3000);
        this.reconnectFuture = this.reconnectTimer.scheduleWithFixedDelay(() -> {
            try {
                this.connect();
            }
            catch (Throwable t) {
                logger.error("Unexpected error occur at reconnect, cause: " + t.getMessage(), t);
            }
        }, this.reconnectPeriod, this.reconnectPeriod, TimeUnit.MILLISECONDS);
    }

    protected final void connect() {
        try {
            if (this.isAvailable()) {
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Reconnect to registry " + this.getUrl());
            }
            this.clientLock.lock();
            try {
                if (this.isAvailable()) {
                    return;
                }
                this.recover();
            }
            finally {
                this.clientLock.unlock();
            }
        }
        catch (Throwable t) {
            if (this.getUrl().getParameter("check", true)) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t.getMessage(), t);
            }
            logger.error("Failed to connect to registry " + this.getUrl().getAddress() + " from provider/consumer " + NetUtils.getLocalHost() + " use dubbo " + Version.getVersion() + ", cause: " + t.getMessage(), t);
        }
    }

    @Override
    public boolean isAvailable() {
        if (this.registryInvoker == null) {
            return false;
        }
        return this.registryInvoker.isAvailable();
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            ExecutorUtil.cancelScheduledFuture(this.reconnectFuture);
        }
        catch (Throwable t) {
            logger.warn("Failed to cancel reconnect timer", t);
        }
        this.registryInvoker.destroy();
        ExecutorUtil.gracefulShutdown(this.reconnectTimer, this.reconnectPeriod);
    }

    @Override
    public void doRegister(URL url) {
        this.registryService.register(url);
    }

    @Override
    public void doUnregister(URL url) {
        this.registryService.unregister(url);
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        this.registryService.subscribe(url, listener);
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.registryService.unsubscribe(url, listener);
    }

    @Override
    public List<URL> lookup(URL url) {
        return this.registryService.lookup(url);
    }
}

