/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ConsumerModel {
    private String serviceKey;
    private final ServiceDescriptor serviceModel;
    private final ReferenceConfigBase<?> referenceConfig;
    private Object proxyObject;
    private Map<String, AsyncMethodInfo> methodConfigs = new HashMap<String, AsyncMethodInfo>();
    private ServiceMetadata serviceMetadata;
    private Map<Method, ConsumerMethodModel> methodModels = new HashMap<Method, ConsumerMethodModel>();

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig) {
        Assert.notEmptyString(serviceKey, "Service name can't be null or blank");
        this.serviceKey = serviceKey;
        this.proxyObject = proxyObject;
        this.serviceModel = serviceModel;
        this.referenceConfig = referenceConfig;
    }

    public void init(Map<String, AsyncMethodInfo> attributes) {
        if (attributes != null) {
            this.methodConfigs = attributes;
        }
        this.initMethodModels();
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public void setProxyObject(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    public Set<MethodDescriptor> getAllMethods() {
        return this.serviceModel.getAllMethods();
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceModel.getServiceInterfaceClass();
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public AsyncMethodInfo getMethodConfig(String methodName) {
        return this.methodConfigs.get(methodName);
    }

    public ServiceDescriptor getServiceModel() {
        return this.serviceModel;
    }

    public ReferenceConfigBase getReferenceConfig() {
        return this.referenceConfig;
    }

    public AsyncMethodInfo getAsyncInfo(String methodName) {
        return this.methodConfigs.get(methodName);
    }

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, ServiceMetadata metadata) {
        this(serviceKey, proxyObject, serviceModel, referenceConfig);
        this.serviceMetadata = metadata;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        if (this.serviceMetadata != null) {
            this.serviceMetadata.setServiceKey(serviceKey);
            this.serviceMetadata.setGroup(BaseServiceMetadata.groupFromServiceKey(serviceKey));
        }
    }

    public void initMethodModels() {
        Class<?>[] interfaceList;
        for (Class<?> interfaceClass : interfaceList = this.serviceMetadata.getTarget().getClass().getInterfaces()) {
            for (Method method : interfaceClass.getMethods()) {
                this.methodModels.put(method, new ConsumerMethodModel(method));
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.serviceMetadata.getServiceType().getClassLoader();
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }

    public ConsumerMethodModel getMethodModel(String method) {
        Optional<Map.Entry> consumerMethodModelEntry = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).findFirst();
        return consumerMethodModelEntry.map(Map.Entry::getValue).orElse(null);
    }

    public ConsumerMethodModel getMethodModel(String method, String[] argsType) {
        Optional<ConsumerMethodModel> consumerMethodModel = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).map(Map.Entry::getValue).filter(methodModel -> Arrays.equals(argsType, methodModel.getParameterTypes())).findFirst();
        return consumerMethodModel.orElse(null);
    }

    public List<ConsumerMethodModel> getAllMethodModels() {
        return new ArrayList<ConsumerMethodModel>(this.methodModels.values());
    }

    public String getServiceName() {
        return this.serviceMetadata.getServiceKey();
    }
}

