/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.webservice;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.wsdl.service.factory.AbstractServiceConfiguration;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.remoting.http.servlet.DispatcherServlet;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;

public class WebServiceProtocol
extends AbstractProxyProtocol {
    public static final int DEFAULT_PORT = 80;
    private final ExtensionManagerBus bus = new ExtensionManagerBus();
    private SoapTransportFactory transportFactory = null;
    private ServerFactoryBean serverFactoryBean = null;
    private DestinationRegistry destinationRegistry = null;
    private HttpBinder httpBinder;
    private Server server = null;

    public WebServiceProtocol() {
        super(Fault.class);
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        this.transportFactory = new SoapTransportFactory();
        this.destinationRegistry = new DestinationRegistryImpl();
        final String addr = this.getAddr(url);
        ProtocolServer protocolServer = (ProtocolServer)this.serverMap.get(addr);
        if (protocolServer == null) {
            HttpServer remotingServer = this.httpBinder.bind(url, new WebServiceHandler());
            this.serverMap.put(addr, new AbstractProxyProtocol.ProxyProtocolServer(remotingServer));
        }
        this.serverFactoryBean = new ServerFactoryBean();
        this.serverFactoryBean.setAddress(url.getAbsolutePath());
        this.serverFactoryBean.setServiceClass(type);
        this.serverFactoryBean.setServiceBean(impl);
        this.serverFactoryBean.setBus((Bus)this.bus);
        this.serverFactoryBean.setDestinationFactory((DestinationFactory)this.transportFactory);
        this.serverFactoryBean.getServiceFactory().getConfigurations().add(new URLHashMethodNameSoapActionServiceConfiguration());
        this.server = this.serverFactoryBean.create();
        return new Runnable(){

            @Override
            public void run() {
                ProtocolServer httpServer;
                if (WebServiceProtocol.this.serverFactoryBean.getServer() != null) {
                    WebServiceProtocol.this.serverFactoryBean.getServer().destroy();
                }
                if (WebServiceProtocol.this.serverFactoryBean.getBus() != null) {
                    WebServiceProtocol.this.serverFactoryBean.getBus().shutdown(true);
                }
                if ((httpServer = (ProtocolServer)WebServiceProtocol.this.serverMap.get(addr)) != null) {
                    httpServer.close();
                    WebServiceProtocol.this.serverMap.remove(addr);
                }
            }
        };
    }

    @Override
    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        ClientProxyFactoryBean proxyFactoryBean = new ClientProxyFactoryBean();
        proxyFactoryBean.setAddress(url.setProtocol("http").toIdentityString());
        proxyFactoryBean.setServiceClass(serviceType);
        proxyFactoryBean.setBus((Bus)this.bus);
        Object ref = proxyFactoryBean.create();
        Client proxy = ClientProxy.getClient((Object)ref);
        HTTPConduit conduit = (HTTPConduit)proxy.getConduit();
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setConnectionTimeout((long)url.getParameter("connect.timeout", 3000));
        policy.setReceiveTimeout((long)url.getParameter("timeout", 1000));
        conduit.setClient(policy);
        return (T)ref;
    }

    @Override
    protected int getErrorCode(Throwable e) {
        if (e instanceof Fault) {
            e = e.getCause();
        }
        if (e instanceof SocketTimeoutException) {
            return 2;
        }
        if (e instanceof IOException) {
            return 1;
        }
        return super.getErrorCode(e);
    }

    private class URLHashMethodNameSoapActionServiceConfiguration
    extends AbstractServiceConfiguration {
        private URLHashMethodNameSoapActionServiceConfiguration() {
        }

        public String getAction(OperationInfo op, Method method) {
            String uri = op.getName().getNamespaceURI();
            String action = op.getName().getLocalPart();
            if (StringUtils.isEmpty((String)action)) {
                action = method.getName();
            }
            return uri + "#" + action;
        }
    }

    private class WebServiceHandler
    implements HttpHandler {
        private volatile ServletController servletController;

        private WebServiceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.servletController == null) {
                DispatcherServlet httpServlet = DispatcherServlet.getInstance();
                if (httpServlet == null) {
                    response.sendError(500, "No such DispatcherServlet instance.");
                    return;
                }
                WebServiceHandler webServiceHandler = this;
                synchronized (webServiceHandler) {
                    if (this.servletController == null) {
                        if (WebServiceProtocol.this.server == null) {
                            WebServiceProtocol.this.server = WebServiceProtocol.this.serverFactoryBean.getServer();
                        }
                        Destination d = WebServiceProtocol.this.transportFactory.getDestination(WebServiceProtocol.this.server.getEndpoint().getEndpointInfo(), (Bus)WebServiceProtocol.this.bus);
                        WebServiceProtocol.this.destinationRegistry.addDestination((AbstractHTTPDestination)d);
                        this.servletController = new ServletController(WebServiceProtocol.this.destinationRegistry, httpServlet.getServletConfig(), (HttpServlet)httpServlet);
                    }
                }
            }
            RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
            this.servletController.invoke(request, response);
        }
    }
}

