/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.lang.ShutdownHookCallback;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.concurrent.ScheduledCompletableFuture;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.bootstrap.builders.ApplicationBuilder;
import org.apache.dubbo.config.bootstrap.builders.ConsumerBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProtocolBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProviderBuilder;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.config.bootstrap.builders.RegistryBuilder;
import org.apache.dubbo.config.bootstrap.builders.ServiceBuilder;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.metadata.ConfigurableMetadataServiceExporter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.event.EventListener;
import org.apache.dubbo.event.GenericEventListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryRegistry;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DubboBootstrap
extends GenericEventListener {
    public static final String DEFAULT_REGISTRY_ID = "REGISTRY#DEFAULT";
    public static final String DEFAULT_PROTOCOL_ID = "PROTOCOL#DEFAULT";
    public static final String DEFAULT_SERVICE_ID = "SERVICE#DEFAULT";
    public static final String DEFAULT_REFERENCE_ID = "REFERENCE#DEFAULT";
    public static final String DEFAULT_PROVIDER_ID = "PROVIDER#DEFAULT";
    public static final String DEFAULT_CONSUMER_ID = "CONSUMER#DEFAULT";
    private static final String NAME = DubboBootstrap.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static DubboBootstrap instance;
    private final AtomicBoolean awaited = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Lock destroyLock = new ReentrantLock();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final EventDispatcher eventDispatcher = EventDispatcher.getDefaultExtension();
    private final ExecutorRepository executorRepository = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    private final ConfigManager configManager;
    private final Environment environment;
    private ReferenceConfigCache cache;
    private volatile boolean exportAsync;
    private volatile boolean referAsync;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean ready = new AtomicBoolean(true);
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private volatile ServiceInstance serviceInstance;
    private volatile MetadataService metadataService;
    private volatile MetadataServiceExporter metadataServiceExporter;
    private List<ServiceConfigBase<?>> exportedServices = new ArrayList();
    private List<Future<?>> asyncExportingFutures = new ArrayList();
    private List<CompletableFuture<Object>> asyncReferringFutures = new ArrayList<CompletableFuture<Object>>();

    public static synchronized DubboBootstrap getInstance() {
        if (instance == null) {
            instance = new DubboBootstrap();
        }
        return instance;
    }

    private DubboBootstrap() {
        this.configManager = ApplicationModel.getConfigManager();
        this.environment = ApplicationModel.getEnvironment();
        DubboShutdownHook.getDubboShutdownHook().register();
        ShutdownHookCallbacks.INSTANCE.addCallback(new ShutdownHookCallback(){

            @Override
            public void callback() throws Throwable {
                DubboBootstrap.this.destroy();
            }
        });
    }

    public void unRegisterShutdownHook() {
        DubboShutdownHook.getDubboShutdownHook().unregister();
    }

    private boolean isOnlyRegisterProvider() {
        Boolean registerConsumer = this.getApplication().getRegisterConsumer();
        return registerConsumer == null || registerConsumer == false;
    }

    private String getMetadataType() {
        String type = this.getApplication().getMetadataType();
        if (StringUtils.isEmpty(type)) {
            type = "local";
        }
        return type;
    }

    public DubboBootstrap metadataReport(MetadataReportConfig metadataReportConfig) {
        this.configManager.addMetadataReport(metadataReportConfig);
        return this;
    }

    public DubboBootstrap metadataReports(List<MetadataReportConfig> metadataReportConfigs) {
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            return this;
        }
        this.configManager.addMetadataReports(metadataReportConfigs);
        return this;
    }

    public DubboBootstrap application(String name) {
        return this.application(name, builder -> {});
    }

    public DubboBootstrap application(String name, Consumer<ApplicationBuilder> consumerBuilder) {
        ApplicationBuilder builder = this.createApplicationBuilder(name);
        consumerBuilder.accept(builder);
        return this.application(builder.build());
    }

    public DubboBootstrap application(ApplicationConfig applicationConfig) {
        this.configManager.setApplication(applicationConfig);
        return this;
    }

    public DubboBootstrap registry(Consumer<RegistryBuilder> consumerBuilder) {
        return this.registry(DEFAULT_REGISTRY_ID, consumerBuilder);
    }

    public DubboBootstrap registry(String id, Consumer<RegistryBuilder> consumerBuilder) {
        RegistryBuilder builder = this.createRegistryBuilder(id);
        consumerBuilder.accept(builder);
        return this.registry(builder.build());
    }

    public DubboBootstrap registry(RegistryConfig registryConfig) {
        this.configManager.addRegistry(registryConfig);
        return this;
    }

    public DubboBootstrap registries(List<RegistryConfig> registryConfigs) {
        if (CollectionUtils.isEmpty(registryConfigs)) {
            return this;
        }
        registryConfigs.forEach(this::registry);
        return this;
    }

    public DubboBootstrap protocol(Consumer<ProtocolBuilder> consumerBuilder) {
        return this.protocol(DEFAULT_PROTOCOL_ID, consumerBuilder);
    }

    public DubboBootstrap protocol(String id, Consumer<ProtocolBuilder> consumerBuilder) {
        ProtocolBuilder builder = this.createProtocolBuilder(id);
        consumerBuilder.accept(builder);
        return this.protocol(builder.build());
    }

    public DubboBootstrap protocol(ProtocolConfig protocolConfig) {
        return this.protocols(Arrays.asList(protocolConfig));
    }

    public DubboBootstrap protocols(List<ProtocolConfig> protocolConfigs) {
        if (CollectionUtils.isEmpty(protocolConfigs)) {
            return this;
        }
        this.configManager.addProtocols(protocolConfigs);
        return this;
    }

    public <S> DubboBootstrap service(Consumer<ServiceBuilder<S>> consumerBuilder) {
        return this.service(DEFAULT_SERVICE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap service(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
        ServiceBuilder builder = this.createServiceBuilder(id);
        consumerBuilder.accept(builder);
        return this.service((ServiceConfig<?>)builder.build());
    }

    public DubboBootstrap service(ServiceConfig<?> serviceConfig) {
        this.configManager.addService(serviceConfig);
        return this;
    }

    public DubboBootstrap services(List<ServiceConfig> serviceConfigs) {
        if (CollectionUtils.isEmpty(serviceConfigs)) {
            return this;
        }
        serviceConfigs.forEach(this.configManager::addService);
        return this;
    }

    public <S> DubboBootstrap reference(Consumer<ReferenceBuilder<S>> consumerBuilder) {
        return this.reference(DEFAULT_REFERENCE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap reference(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
        ReferenceBuilder builder = this.createReferenceBuilder(id);
        consumerBuilder.accept(builder);
        return this.reference((ReferenceConfig<?>)builder.build());
    }

    public DubboBootstrap reference(ReferenceConfig<?> referenceConfig) {
        this.configManager.addReference(referenceConfig);
        return this;
    }

    public DubboBootstrap references(List<ReferenceConfig> referenceConfigs) {
        if (CollectionUtils.isEmpty(referenceConfigs)) {
            return this;
        }
        referenceConfigs.forEach(this.configManager::addReference);
        return this;
    }

    public DubboBootstrap provider(Consumer<ProviderBuilder> builderConsumer) {
        return this.provider(DEFAULT_PROVIDER_ID, builderConsumer);
    }

    public DubboBootstrap provider(String id, Consumer<ProviderBuilder> builderConsumer) {
        ProviderBuilder builder = this.createProviderBuilder(id);
        builderConsumer.accept(builder);
        return this.provider(builder.build());
    }

    public DubboBootstrap provider(ProviderConfig providerConfig) {
        return this.providers(Arrays.asList(providerConfig));
    }

    public DubboBootstrap providers(List<ProviderConfig> providerConfigs) {
        if (CollectionUtils.isEmpty(providerConfigs)) {
            return this;
        }
        providerConfigs.forEach(this.configManager::addProvider);
        return this;
    }

    public DubboBootstrap consumer(Consumer<ConsumerBuilder> builderConsumer) {
        return this.consumer(DEFAULT_CONSUMER_ID, builderConsumer);
    }

    public DubboBootstrap consumer(String id, Consumer<ConsumerBuilder> builderConsumer) {
        ConsumerBuilder builder = this.createConsumerBuilder(id);
        builderConsumer.accept(builder);
        return this.consumer(builder.build());
    }

    public DubboBootstrap consumer(ConsumerConfig consumerConfig) {
        return this.consumers(Arrays.asList(consumerConfig));
    }

    public DubboBootstrap consumers(List<ConsumerConfig> consumerConfigs) {
        if (CollectionUtils.isEmpty(consumerConfigs)) {
            return this;
        }
        consumerConfigs.forEach(this.configManager::addConsumer);
        return this;
    }

    public DubboBootstrap configCenter(ConfigCenterConfig configCenterConfig) {
        return this.configCenters(Arrays.asList(configCenterConfig));
    }

    public DubboBootstrap configCenters(List<ConfigCenterConfig> configCenterConfigs) {
        if (CollectionUtils.isEmpty(configCenterConfigs)) {
            return this;
        }
        this.configManager.addConfigCenters(configCenterConfigs);
        return this;
    }

    public DubboBootstrap monitor(MonitorConfig monitor) {
        this.configManager.setMonitor(monitor);
        return this;
    }

    public DubboBootstrap metrics(MetricsConfig metrics) {
        this.configManager.setMetrics(metrics);
        return this;
    }

    public DubboBootstrap module(ModuleConfig module) {
        this.configManager.setModule(module);
        return this;
    }

    public DubboBootstrap ssl(SslConfig sslConfig) {
        this.configManager.setSsl(sslConfig);
        return this;
    }

    public DubboBootstrap cache(ReferenceConfigCache cache) {
        this.cache = cache;
        return this;
    }

    public ReferenceConfigCache getCache() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        return this.cache;
    }

    public DubboBootstrap exportAsync() {
        this.exportAsync = true;
        return this;
    }

    public DubboBootstrap referAsync() {
        this.referAsync = true;
        return this;
    }

    @Deprecated
    public void init() {
        this.initialize();
    }

    private void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        ApplicationModel.initFrameworkExts();
        this.startConfigCenter();
        this.useRegistryAsConfigCenterIfNecessary();
        this.loadRemoteConfigs();
        this.checkGlobalConfigs();
        this.initMetadataService();
        this.initEventListener();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(NAME + " has been initialized!");
        }
    }

    private void checkGlobalConfigs() {
        Collection<ProviderConfig> providers;
        ConfigValidationUtils.validateApplicationConfig(this.getApplication());
        Collection<MetadataReportConfig> metadatas = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty(metadatas)) {
            MetadataReportConfig metadataReportConfig = new MetadataReportConfig();
            metadataReportConfig.refresh();
            if (metadataReportConfig.isValid()) {
                this.configManager.addMetadataReport(metadataReportConfig);
                metadatas = this.configManager.getMetadataConfigs();
            }
        }
        if (CollectionUtils.isNotEmpty(metadatas)) {
            for (MetadataReportConfig metadataReportConfig : metadatas) {
                metadataReportConfig.refresh();
                ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            }
        }
        if (CollectionUtils.isEmpty(providers = this.configManager.getProviders())) {
            this.configManager.getDefaultProvider().orElseGet(() -> {
                ProviderConfig providerConfig = new ProviderConfig();
                this.configManager.addProvider(providerConfig);
                providerConfig.refresh();
                return providerConfig;
            });
        }
        for (ProviderConfig providerConfig : this.configManager.getProviders()) {
            ConfigValidationUtils.validateProviderConfig(providerConfig);
        }
        Collection<ConsumerConfig> collection = this.configManager.getConsumers();
        if (CollectionUtils.isEmpty(collection)) {
            this.configManager.getDefaultConsumer().orElseGet(() -> {
                ConsumerConfig consumerConfig = new ConsumerConfig();
                this.configManager.addConsumer(consumerConfig);
                consumerConfig.refresh();
                return consumerConfig;
            });
        }
        for (ConsumerConfig consumerConfig : this.configManager.getConsumers()) {
            ConfigValidationUtils.validateConsumerConfig(consumerConfig);
        }
        ConfigValidationUtils.validateMonitorConfig(this.getMonitor());
        ConfigValidationUtils.validateMetricsConfig(this.getMetrics());
        ConfigValidationUtils.validateModuleConfig(this.getModule());
        ConfigValidationUtils.validateSslConfig(this.getSsl());
    }

    private void startConfigCenter() {
        Collection<ConfigCenterConfig> configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty(configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.refresh();
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty(configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration(compositeDynamicConfiguration);
        }
        this.configManager.refreshAll();
    }

    private void startMetadataReport() {
        ApplicationConfig applicationConfig = this.getApplication();
        String metadataType = applicationConfig.getMetadataType();
        Collection<MetadataReportConfig> metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, you must specify the remote Metadata Center address when 'metadata=remote' is enabled.");
            }
            return;
        }
        MetadataReportConfig metadataReportConfig = metadataReportConfigs.iterator().next();
        ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
        if (!metadataReportConfig.isValid()) {
            return;
        }
        MetadataReportInstance.init(metadataReportConfig.toUrl());
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.configManager.getConfigCenters())) {
            return;
        }
        this.configManager.getDefaultRegistries().stream().filter(registryConfig -> registryConfig.getUseAsConfigCenter() == null || registryConfig.getUseAsConfigCenter() != false).forEach(registryConfig -> {
            String protocol = registryConfig.getProtocol();
            String id = "config-center-" + protocol + "-" + registryConfig.getPort();
            ConfigCenterConfig cc = new ConfigCenterConfig();
            cc.setId(id);
            if (cc.getParameters() == null) {
                cc.setParameters(new HashMap<String, String>());
            }
            if (registryConfig.getParameters() != null) {
                cc.getParameters().putAll(registryConfig.getParameters());
            }
            cc.getParameters().put("client", registryConfig.getClient());
            cc.setProtocol(registryConfig.getProtocol());
            cc.setPort(registryConfig.getPort());
            cc.setAddress(registryConfig.getAddress());
            cc.setNamespace(registryConfig.getGroup());
            cc.setUsername(registryConfig.getUsername());
            cc.setPassword(registryConfig.getPassword());
            if (registryConfig.getTimeout() != null) {
                cc.setTimeout(registryConfig.getTimeout().longValue());
            }
            cc.setHighestPriority(false);
            this.configManager.addConfigCenter(cc);
        });
        this.startConfigCenter();
    }

    private void loadRemoteConfigs() {
        ArrayList<RegistryConfig> tmpRegistries = new ArrayList<RegistryConfig>();
        Set<String> registryIds = this.configManager.getRegistryIds();
        registryIds.forEach(id -> {
            if (tmpRegistries.stream().noneMatch(reg -> reg.getId().equals(id))) {
                tmpRegistries.add(this.configManager.getRegistry((String)id).orElseGet(() -> {
                    RegistryConfig registryConfig = new RegistryConfig();
                    registryConfig.setId((String)id);
                    registryConfig.refresh();
                    return registryConfig;
                }));
            }
        });
        this.configManager.addRegistries(tmpRegistries);
        ArrayList<ProtocolConfig> tmpProtocols = new ArrayList<ProtocolConfig>();
        Set<String> protocolIds = this.configManager.getProtocolIds();
        protocolIds.forEach(id -> {
            if (tmpProtocols.stream().noneMatch(prot -> prot.getId().equals(id))) {
                tmpProtocols.add(this.configManager.getProtocol((String)id).orElseGet(() -> {
                    ProtocolConfig protocolConfig = new ProtocolConfig();
                    protocolConfig.setId((String)id);
                    protocolConfig.refresh();
                    return protocolConfig;
                }));
            }
        });
        this.configManager.addProtocols(tmpProtocols);
    }

    private void initMetadataService() {
        this.startMetadataReport();
        this.metadataService = WritableMetadataService.getExtension(this.getMetadataType());
        this.metadataServiceExporter = new ConfigurableMetadataServiceExporter(this.metadataService);
    }

    private void initEventListener() {
        this.addEventListener(this);
    }

    private List<ServiceDiscovery> getServiceDiscoveries() {
        return AbstractRegistryFactory.getRegistries().stream().filter(registry -> registry instanceof ServiceDiscoveryRegistry).map(registry -> (ServiceDiscoveryRegistry)registry).map(ServiceDiscoveryRegistry::getServiceDiscovery).collect(Collectors.toList());
    }

    public DubboBootstrap start() {
        if (this.started.compareAndSet(false, true)) {
            this.ready.set(false);
            this.initialize();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(NAME + " is starting...");
            }
            this.exportServices();
            if (!this.isOnlyRegisterProvider() || this.hasExportedServices()) {
                this.exportMetadataService();
                this.registerServiceInstance();
            }
            this.referServices();
            if (this.asyncExportingFutures.size() > 0) {
                new Thread(() -> {
                    try {
                        this.awaitFinish();
                    }
                    catch (Exception e) {
                        this.logger.warn(NAME + " exportAsync occurred an exception.");
                    }
                    this.ready.set(true);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(NAME + " is ready.");
                    }
                }).start();
            } else {
                this.ready.set(true);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is ready.");
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(NAME + " has started.");
            }
        }
        return this;
    }

    private boolean hasExportedServices() {
        return !this.metadataService.getExportedURLs().isEmpty();
    }

    public DubboBootstrap await() {
        if (!this.awaited.get() && !this.executorService.isShutdown()) {
            this.executeMutually(() -> {
                while (!this.awaited.get()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(NAME + " awaiting ...");
                    }
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        return this;
    }

    public DubboBootstrap awaitFinish() throws Exception {
        CompletableFuture<Void> future;
        this.logger.info(NAME + " waiting services exporting / referring ...");
        if (this.exportAsync && this.asyncExportingFutures.size() > 0) {
            future = CompletableFuture.allOf(this.asyncExportingFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        if (this.referAsync && this.asyncReferringFutures.size() > 0) {
            future = CompletableFuture.allOf(this.asyncReferringFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        this.logger.info("Service export / refer finished.");
        return this;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isReady() {
        return this.ready.get();
    }

    public DubboBootstrap stop() throws IllegalStateException {
        this.destroy();
        return this;
    }

    private ApplicationBuilder createApplicationBuilder(String name) {
        return new ApplicationBuilder().name(name);
    }

    private RegistryBuilder createRegistryBuilder(String id) {
        return new RegistryBuilder().id(id);
    }

    private ProtocolBuilder createProtocolBuilder(String id) {
        return new ProtocolBuilder().id(id);
    }

    private ServiceBuilder createServiceBuilder(String id) {
        return new ServiceBuilder().id(id);
    }

    private ReferenceBuilder createReferenceBuilder(String id) {
        return new ReferenceBuilder().id(id);
    }

    private ProviderBuilder createProviderBuilder(String id) {
        return (ProviderBuilder)new ProviderBuilder().id(id);
    }

    private ConsumerBuilder createConsumerBuilder(String id) {
        return (ConsumerBuilder)new ConsumerBuilder().id(id);
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            if (!configCenter.checkOrUpdateInited()) {
                return null;
            }
            DynamicConfiguration dynamicConfiguration = DynamicConfiguration.getDynamicConfiguration(configCenter.toUrl());
            String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
            String appGroup = this.getApplication().getName();
            String appConfigContent = null;
            if (StringUtils.isNotEmpty(appGroup)) {
                appConfigContent = dynamicConfiguration.getProperties(StringUtils.isNotEmpty(configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup);
            }
            try {
                this.environment.setConfigCenterFirst(configCenter.isHighestPriority());
                this.environment.updateExternalConfigurationMap(ConfigurationUtils.parseProperties(configContent));
                this.environment.updateAppExternalConfigurationMap(ConfigurationUtils.parseProperties(appConfigContent));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
            }
            return dynamicConfiguration;
        }
        return null;
    }

    public DubboBootstrap addEventListener(EventListener<?> listener) {
        this.eventDispatcher.addEventListener(listener);
        return this;
    }

    private void exportMetadataService() {
        this.metadataServiceExporter.export();
    }

    private void unexportMetadataService() {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            this.metadataServiceExporter.unexport();
        }
    }

    private void exportServices() {
        this.configManager.getServices().forEach(sc -> {
            ServiceConfig serviceConfig = (ServiceConfig)sc;
            serviceConfig.setBootstrap(this);
            if (this.exportAsync) {
                ScheduledExecutorService executor = this.executorRepository.getServiceExporterExecutor();
                Future<?> future = executor.submit(() -> {
                    sc.export();
                    this.exportedServices.add((ServiceConfigBase<?>)sc);
                });
                this.asyncExportingFutures.add(future);
            } else {
                sc.export();
                this.exportedServices.add((ServiceConfigBase<?>)sc);
            }
        });
    }

    private void unexportServices() {
        this.exportedServices.forEach(sc -> {
            this.configManager.removeConfig((AbstractConfig)sc);
            sc.unexport();
        });
        this.asyncExportingFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncExportingFutures.clear();
        this.exportedServices.clear();
    }

    private void referServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.configManager.getReferences().forEach(rc -> {
            ReferenceConfig referenceConfig = (ReferenceConfig)rc;
            referenceConfig.setBootstrap(this);
            if (rc.shouldInit()) {
                if (this.referAsync) {
                    CompletableFuture<Object> future = ScheduledCompletableFuture.submit(this.executorRepository.getServiceExporterExecutor(), () -> this.cache.get(rc));
                    this.asyncReferringFutures.add(future);
                } else {
                    this.cache.get(rc);
                }
            }
        });
    }

    private void unreferServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.asyncReferringFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncReferringFutures.clear();
        this.cache.destroyAll();
    }

    private void registerServiceInstance() {
        if (CollectionUtils.isEmpty(this.getServiceDiscoveries())) {
            return;
        }
        ApplicationConfig application = this.getApplication();
        String serviceName = application.getName();
        URL exportedURL = this.selectMetadataServiceExportedURL();
        String host = exportedURL.getHost();
        int port = exportedURL.getPort();
        ServiceInstance serviceInstance = this.createServiceInstance(serviceName, host, port);
        this.getServiceDiscoveries().forEach(serviceDiscovery -> serviceDiscovery.register(serviceInstance));
    }

    private URL selectMetadataServiceExportedURL() {
        URL selectedURL = null;
        SortedSet<String> urlValues = this.metadataService.getExportedURLs();
        for (String urlValue : urlValues) {
            URL url = URL.valueOf(urlValue);
            if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
            if ("rest".equals(url.getProtocol())) {
                selectedURL = url;
                break;
            }
            selectedURL = url;
        }
        if (selectedURL == null && CollectionUtils.isNotEmpty(urlValues)) {
            selectedURL = URL.valueOf((String)urlValues.iterator().next());
        }
        return selectedURL;
    }

    private void unregisterServiceInstance() {
        if (this.serviceInstance != null) {
            this.getServiceDiscoveries().forEach(serviceDiscovery -> serviceDiscovery.unregister(this.serviceInstance));
        }
    }

    private ServiceInstance createServiceInstance(String serviceName, String host, int port) {
        this.serviceInstance = new DefaultServiceInstance(serviceName, host, port);
        ServiceInstanceMetadataUtils.setMetadataStorageType(this.serviceInstance, this.getMetadataType());
        return this.serviceInstance;
    }

    public void destroy() {
        if (this.destroyLock.tryLock()) {
            try {
                DubboShutdownHook.destroyAll();
                if (this.started.compareAndSet(true, false) && this.destroyed.compareAndSet(false, true)) {
                    this.unregisterServiceInstance();
                    this.unexportMetadataService();
                    this.unexportServices();
                    this.unreferServices();
                    this.destroyRegistries();
                    DubboShutdownHook.destroyProtocols();
                    this.destroyServiceDiscoveries();
                    this.clear();
                    this.shutdown();
                    this.release();
                }
            }
            finally {
                this.destroyLock.unlock();
            }
        }
    }

    private void destroyRegistries() {
        AbstractRegistryFactory.destroyAll();
    }

    private void destroyServiceDiscoveries() {
        this.getServiceDiscoveries().forEach(serviceDiscovery -> ThrowableAction.execute(serviceDiscovery::destroy));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void clear() {
        this.clearConfigs();
        this.clearApplicationModel();
    }

    private void clearApplicationModel() {
    }

    private void clearConfigs() {
        this.configManager.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s configs have been clear.");
        }
    }

    private void release() {
        this.executeMutually(() -> {
            while (this.awaited.compareAndSet(false, true)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is about to shutdown...");
                }
                this.condition.signalAll();
            }
        });
    }

    private void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ApplicationConfig getApplication() {
        ApplicationConfig application = this.configManager.getApplication().orElseGet(() -> {
            ApplicationConfig applicationConfig = new ApplicationConfig();
            this.configManager.setApplication(applicationConfig);
            return applicationConfig;
        });
        application.refresh();
        return application;
    }

    private MonitorConfig getMonitor() {
        MonitorConfig monitor = this.configManager.getMonitor().orElseGet(() -> {
            MonitorConfig monitorConfig = new MonitorConfig();
            this.configManager.setMonitor(monitorConfig);
            return monitorConfig;
        });
        monitor.refresh();
        return monitor;
    }

    private MetricsConfig getMetrics() {
        MetricsConfig metrics = this.configManager.getMetrics().orElseGet(() -> {
            MetricsConfig metricsConfig = new MetricsConfig();
            this.configManager.setMetrics(metricsConfig);
            return metricsConfig;
        });
        metrics.refresh();
        return metrics;
    }

    private ModuleConfig getModule() {
        ModuleConfig module = this.configManager.getModule().orElseGet(() -> {
            ModuleConfig moduleConfig = new ModuleConfig();
            this.configManager.setModule(moduleConfig);
            return moduleConfig;
        });
        module.refresh();
        return module;
    }

    private SslConfig getSsl() {
        SslConfig ssl = this.configManager.getSsl().orElseGet(() -> {
            SslConfig sslConfig = new SslConfig();
            this.configManager.setSsl(sslConfig);
            return sslConfig;
        });
        ssl.refresh();
        return ssl;
    }
}

