/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.consul;

import com.google.common.base.Charsets;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.KVCache;
import com.orbitz.consul.model.kv.Value;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class ConsulDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ConsulDynamicConfiguration.class);
    private static final int DEFAULT_PORT = 8500;
    private static final int DEFAULT_WATCH_TIMEOUT = 60000;
    private static final String WATCH_TIMEOUT = "consul-watch-timeout";
    private URL url;
    private String rootPath;
    private Consul client;
    private KeyValueClient kvClient;
    private ConcurrentMap<String, ConsulListener> watchers = new ConcurrentHashMap<String, ConsulListener>();

    public ConsulDynamicConfiguration(URL url) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/" + "config";
        String host = url.getHost();
        int port = url.getPort() != 0 ? url.getPort() : 8500;
        this.client = Consul.builder().withHostAndPort(HostAndPort.fromParts((String)host, (int)port)).build();
        this.kvClient = this.client.keyValueClient();
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        logger.info("register listener " + listener.getClass() + " for config with key: " + key + ", group: " + group);
        String normalizedKey = this.convertKey(group, key);
        ConsulListener watcher = this.watchers.computeIfAbsent(normalizedKey, k -> new ConsulListener(key, group));
        watcher.addListener(listener);
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        logger.info("unregister listener " + listener.getClass() + " for config with key: " + key + ", group: " + group);
        ConsulListener watcher = (ConsulListener)this.watchers.get(this.convertKey(group, key));
        if (watcher != null) {
            watcher.removeListener(listener);
        }
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public SortedSet<String> getConfigKeys(String group) throws UnsupportedOperationException {
        TreeSet<String> configKeys = new TreeSet<String>();
        String normalizedKey = this.convertKey(group, "");
        List keys = this.kvClient.getKeys(normalizedKey);
        if (CollectionUtils.isNotEmpty(keys)) {
            keys.stream().filter(k -> !k.equals(normalizedKey)).map(k -> k.substring(k.lastIndexOf("/") + 1)).forEach(configKeys::add);
        }
        return configKeys;
    }

    @Override
    public boolean publishConfig(String key, String group, String content) throws UnsupportedOperationException {
        String normalizedKey = this.convertKey(group, key);
        return this.kvClient.putValue(normalizedKey + "/" + content);
    }

    @Override
    public Object getInternalProperty(String key) {
        logger.info("getting config from: " + key);
        return this.kvClient.getValueAsString(key, Charsets.UTF_8).orElse(null);
    }

    @Override
    public void close() throws Exception {
        this.client.destroy();
    }

    private String buildPath(String group) {
        String actualGroup = StringUtils.isEmpty(group) ? "dubbo" : group;
        return this.rootPath + "/" + actualGroup;
    }

    private String convertKey(String group, String key) {
        return this.buildPath(group) + "/" + key;
    }

    private class ConsulListener
    implements ConsulCache.Listener<String, Value> {
        private KVCache kvCache;
        private Set<ConfigurationListener> listeners = new LinkedHashSet<ConfigurationListener>();
        private String key;
        private String group;
        private String normalizedKey;

        public ConsulListener(String key, String group) {
            this.key = key;
            this.group = group;
            this.normalizedKey = ConsulDynamicConfiguration.this.convertKey(group, key);
            this.initKVCache();
        }

        private void initKVCache() {
            this.kvCache = KVCache.newCache((KeyValueClient)ConsulDynamicConfiguration.this.kvClient, (String)this.normalizedKey);
            this.kvCache.addListener((ConsulCache.Listener)this);
            this.kvCache.start();
        }

        public void notify(Map<String, Value> newValues) {
            Optional<Value> newValue = newValues.values().stream().filter(value -> value.getKey().equals(this.normalizedKey)).findAny();
            newValue.ifPresent(value -> {
                Optional decodedValue = ((Value)newValue.get()).getValueAsString();
                decodedValue.ifPresent(v -> this.listeners.forEach(l -> {
                    ConfigChangedEvent event = new ConfigChangedEvent(this.key, this.group, (String)v, ConfigChangeType.MODIFIED);
                    l.process(event);
                }));
            });
        }

        private void addListener(ConfigurationListener listener) {
            this.listeners.add(listener);
        }

        private void removeListener(ConfigurationListener listener) {
            this.listeners.remove(listener);
        }
    }
}

