/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;

public abstract class ServiceInstanceMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public final void customize(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String propertyName = this.resolveMetadataPropertyName(serviceInstance);
        String propertyValue = this.resolveMetadataPropertyValue(serviceInstance);
        if (!StringUtils.isBlank(propertyName) && !StringUtils.isBlank(propertyValue)) {
            boolean put;
            String existedValue = metadata.get(propertyName);
            boolean bl = put = existedValue == null || this.isOverride();
            if (put) {
                metadata.put(propertyName, propertyValue);
            }
        }
    }

    protected abstract String resolveMetadataPropertyName(ServiceInstance var1);

    protected abstract String resolveMetadataPropertyValue(ServiceInstance var1);

    protected boolean isOverride() {
        return false;
    }
}

