/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.HashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public class ProtocolPortsMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        String metadataStoredType = ServiceInstanceMetadataUtils.getMetadataStorageType(serviceInstance);
        WritableMetadataService writableMetadataService = WritableMetadataService.getExtension(metadataStoredType);
        HashMap<String, Integer> protocols = new HashMap<String, Integer>();
        writableMetadataService.getExportedURLs().stream().map(URL::valueOf).filter(url -> !MetadataService.class.getName().equals(url.getServiceInterface())).forEach(url -> protocols.put(url.getProtocol(), url.getPort()));
        ServiceInstanceMetadataUtils.setEndpoints(serviceInstance, protocols);
    }
}

