/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.nacos.NacosServiceName;
import org.apache.dubbo.registry.nacos.util.NacosInstanceManageUtil;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class NacosRegistry
extends FailbackRegistry {
    private static final List<String> ALL_SUPPORTED_CATEGORIES = Arrays.asList("providers", "consumers", "routers", "configurators");
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private static final String WILDCARD = "*";
    private static final String SERVICE_NAME_SEPARATOR = System.getProperty("nacos.service.name.separator", ":");
    private static final int PAGINATION_SIZE = Integer.getInteger("nacos.service.names.pagination.size", 100);
    private static final long LOOKUP_INTERVAL = Long.getLong("nacos.service.names.lookup.interval", 30L);
    private volatile ScheduledExecutorService scheduledExecutorService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NamingService namingService;

    public NacosRegistry(URL url, NamingService namingService) {
        super(url);
        this.namingService = namingService;
    }

    @Override
    public boolean isAvailable() {
        return "UP".equals(this.namingService.getServerStatus());
    }

    @Override
    public List<URL> lookup(URL url) {
        LinkedList<URL> urls = new LinkedList<URL>();
        this.execute(namingService -> {
            Set<String> serviceNames = this.getServiceNames(url, null);
            for (String serviceName : serviceNames) {
                List instances = namingService.getAllInstances(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"));
                urls.addAll(this.buildURLs(url, instances));
            }
        });
        return urls;
    }

    @Override
    public void doRegister(URL url) {
        String serviceName = this.getServiceName(url);
        Instance instance = this.createInstance(url);
        this.execute(namingService -> namingService.registerInstance(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"), instance));
    }

    @Override
    public void doUnregister(URL url) {
        this.execute(namingService -> {
            String serviceName = this.getServiceName(url);
            Instance instance = this.createInstance(url);
            namingService.deregisterInstance(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"), instance.getIp(), instance.getPort());
        });
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        Set<String> serviceNames = this.getServiceNames(url, listener);
        if (this.isServiceNamesWithCompatibleMode(url)) {
            for (String serviceName : serviceNames) {
                NacosInstanceManageUtil.setCorrespondingServiceNames(serviceName, serviceNames);
            }
        }
        this.doSubscribe(url, listener, serviceNames);
    }

    private void doSubscribe(URL url, NotifyListener listener, Set<String> serviceNames) {
        this.execute(namingService -> {
            if (this.isServiceNamesWithCompatibleMode(url)) {
                ArrayList allCorrespondingInstanceList = Lists.newArrayList();
                for (String serviceName : serviceNames) {
                    List instances = namingService.getAllInstances(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"));
                    NacosInstanceManageUtil.initOrRefreshServiceInstanceList(serviceName, instances);
                    allCorrespondingInstanceList.addAll(instances);
                }
                this.notifySubscriber(url, listener, allCorrespondingInstanceList);
                for (String serviceName : serviceNames) {
                    this.subscribeEventListener(serviceName, url, listener);
                }
            } else {
                LinkedList<Instance> instances = new LinkedList<Instance>();
                for (String serviceName : serviceNames) {
                    instances.addAll(namingService.getAllInstances(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP")));
                    this.notifySubscriber(url, listener, instances);
                    this.subscribeEventListener(serviceName, url, listener);
                }
            }
        });
    }

    private boolean isServiceNamesWithCompatibleMode(URL url) {
        return !this.isAdminProtocol(url) && this.createServiceName(url).isConcrete();
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.shutdownServiceNamesLookup();
        }
    }

    private void shutdownServiceNamesLookup() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private Set<String> getServiceNames(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.scheduleServiceNamesLookup(url, listener);
            return this.getServiceNamesForOps(url);
        }
        return this.getServiceNames0(url);
    }

    private Set<String> getServiceNames0(URL url) {
        LinkedHashSet<String> serviceNames;
        NacosServiceName serviceName = this.createServiceName(url);
        if (serviceName.isConcrete()) {
            serviceNames = new LinkedHashSet();
            serviceNames.add(serviceName.toString());
            String legacySubscribedServiceName = this.getLegacySubscribedServiceName(url);
            if (!serviceName.toString().equals(legacySubscribedServiceName)) {
                serviceNames.add(legacySubscribedServiceName);
            }
        } else {
            serviceNames = this.filterServiceNames(serviceName);
        }
        return serviceNames;
    }

    private Set<String> filterServiceNames(NacosServiceName serviceName) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(namingService -> serviceNames.addAll(namingService.getServicesOfServer(1, Integer.MAX_VALUE, this.getUrl().getParameter("group", "DEFAULT_GROUP")).getData().stream().map(NacosServiceName::new).filter(serviceName::isCompatible).map(NacosServiceName::toString).collect(Collectors.toList())));
        return serviceNames;
    }

    private String getLegacySubscribedServiceName(URL url) {
        StringBuilder serviceNameBuilder = new StringBuilder("providers");
        this.appendIfPresent(serviceNameBuilder, url, "interface");
        this.appendIfPresent(serviceNameBuilder, url, "version");
        this.appendIfPresent(serviceNameBuilder, url, "group");
        return serviceNameBuilder.toString();
    }

    private void appendIfPresent(StringBuilder target, URL url, String parameterName) {
        String parameterValue = url.getParameter(parameterName);
        if (!StringUtils.isBlank((CharSequence)parameterValue)) {
            target.append(SERVICE_NAME_SEPARATOR).append(parameterValue);
        }
    }

    private boolean isAdminProtocol(URL url) {
        return "admin".equals(url.getProtocol());
    }

    private void scheduleServiceNamesLookup(URL url, NotifyListener listener) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Set<String> serviceNames = this.getAllServiceNames();
                this.filterData(serviceNames, serviceName -> {
                    boolean accepted = false;
                    for (String category : ALL_SUPPORTED_CATEGORIES) {
                        String prefix = category + SERVICE_NAME_SEPARATOR;
                        if (serviceName == null || !serviceName.startsWith(prefix)) continue;
                        accepted = true;
                        break;
                    }
                    return accepted;
                });
                this.doSubscribe(url, listener, serviceNames);
            }, LOOKUP_INTERVAL, LOOKUP_INTERVAL, TimeUnit.SECONDS);
        }
    }

    private Set<String> getServiceNamesForOps(URL url) {
        Set<String> serviceNames = this.getAllServiceNames();
        this.filterServiceNames(serviceNames, url);
        return serviceNames;
    }

    private Set<String> getAllServiceNames() {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(namingService -> {
            int pageIndex = 1;
            ListView listView = namingService.getServicesOfServer(pageIndex, PAGINATION_SIZE, this.getUrl().getParameter("group", "DEFAULT_GROUP"));
            List firstPageData = listView.getData();
            serviceNames.addAll(firstPageData);
            int count = listView.getCount();
            int pageNumbers = count / PAGINATION_SIZE;
            int remainder = count % PAGINATION_SIZE;
            if (remainder > 0) {
                ++pageNumbers;
            }
            while (pageIndex < pageNumbers) {
                listView = namingService.getServicesOfServer(++pageIndex, PAGINATION_SIZE, this.getUrl().getParameter("group", "DEFAULT_GROUP"));
                serviceNames.addAll(listView.getData());
            }
        });
        return serviceNames;
    }

    private void filterServiceNames(Set<String> serviceNames, URL url) {
        List<String> categories = this.getCategories(url);
        String targetServiceInterface = url.getServiceInterface();
        String targetVersion = url.getParameter("version", "");
        String targetGroup = url.getParameter("group", "");
        this.filterData(serviceNames, serviceName -> {
            String[] segments = serviceName.split(SERVICE_NAME_SEPARATOR, -1);
            int length = segments.length;
            if (length != 4) {
                return false;
            }
            String category = segments[0];
            if (!categories.contains(category)) {
                return false;
            }
            String serviceInterface = segments[1];
            if (!WILDCARD.equals(targetServiceInterface) && !org.apache.dubbo.common.utils.StringUtils.isEquals(targetServiceInterface, serviceInterface)) {
                return false;
            }
            String version = segments[2];
            if (!WILDCARD.equals(targetVersion) && !org.apache.dubbo.common.utils.StringUtils.isEquals(targetVersion, version)) {
                return false;
            }
            String group = segments[3];
            return group == null || WILDCARD.equals(targetGroup) || org.apache.dubbo.common.utils.StringUtils.isEquals(targetGroup, group);
        });
    }

    private <T> void filterData(Collection<T> collection, NacosDataFilter<T> filter) {
        collection.removeIf(data -> !filter.accept(data));
    }

    @Deprecated
    private List<String> doGetServiceNames(URL url) {
        List<String> categories = this.getCategories(url);
        ArrayList<String> serviceNames = new ArrayList<String>(categories.size());
        for (String category : categories) {
            String serviceName = this.getServiceName(url, category);
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    private List<URL> toUrlWithEmpty(URL consumerURL, Collection<Instance> instances) {
        List<URL> urls = this.buildURLs(consumerURL, instances);
        if (urls.size() == 0) {
            URL empty = URLBuilder.from(consumerURL).setProtocol("empty").addParameter("category", "providers").build();
            urls.add(empty);
        }
        return urls;
    }

    private List<URL> buildURLs(URL consumerURL, Collection<Instance> instances) {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (instances != null && !instances.isEmpty()) {
            for (Instance instance : instances) {
                URL url = this.buildURL(instance);
                if (!UrlUtils.isMatch(consumerURL, url)) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private void subscribeEventListener(String serviceName, URL url, NotifyListener listener) throws NacosException {
        EventListener eventListener = event -> {
            if (event instanceof NamingEvent) {
                NamingEvent e = (NamingEvent)event;
                List<Instance> instances = e.getInstances();
                if (this.isServiceNamesWithCompatibleMode(url)) {
                    NacosInstanceManageUtil.initOrRefreshServiceInstanceList(serviceName, instances);
                    instances = NacosInstanceManageUtil.getAllCorrespondingServiceInstanceList(serviceName);
                }
                this.notifySubscriber(url, listener, (Collection<Instance>)instances);
            }
        };
        this.namingService.subscribe(serviceName, this.getUrl().getParameter("group", "DEFAULT_GROUP"), eventListener);
    }

    private void notifySubscriber(URL url, NotifyListener listener, Collection<Instance> instances) {
        LinkedList<Instance> healthyInstances = new LinkedList<Instance>(instances);
        if (healthyInstances.size() > 0) {
            this.filterHealthyInstances(healthyInstances);
        }
        List<URL> urls = this.toUrlWithEmpty(url, healthyInstances);
        this.notify(url, listener, urls);
    }

    private List<String> getCategories(URL url) {
        return WILDCARD.equals(url.getServiceInterface()) ? ALL_SUPPORTED_CATEGORIES : Arrays.asList("providers");
    }

    private URL buildURL(Instance instance) {
        Map metadata = instance.getMetadata();
        String protocol = (String)metadata.get("protocol");
        String path = (String)metadata.get("path");
        return new URL(protocol, instance.getIp(), instance.getPort(), path, instance.getMetadata());
    }

    private Instance createInstance(URL url) {
        String category = url.getParameter("category", "providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        newURL = newURL.addParameter("path", url.getPath());
        String ip = url.getHost();
        int port = url.getPort();
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setMetadata(new HashMap<String, String>(newURL.getParameters()));
        return instance;
    }

    private NacosServiceName createServiceName(URL url) {
        return NacosServiceName.valueOf(url);
    }

    private String getServiceName(URL url) {
        return this.getServiceName(url, url.getParameter("category", "providers"));
    }

    private String getServiceName(URL url, String category) {
        return category + SERVICE_NAME_SEPARATOR + url.getColonSeparatedKey();
    }

    private void execute(NamingServiceCallback callback) {
        block2: {
            try {
                callback.callback(this.namingService);
            }
            catch (NacosException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getErrMsg(), e);
            }
        }
    }

    private void filterHealthyInstances(Collection<Instance> instances) {
        this.filterData(instances, Instance::isEnabled);
    }

    static interface NamingServiceCallback {
        public void callback(NamingService var1) throws NacosException;
    }

    private static interface NacosDataFilter<T> {
        public boolean accept(T var1);
    }
}

