/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.retry.FailedNotifiedTask;
import org.apache.dubbo.registry.retry.FailedRegisteredTask;
import org.apache.dubbo.registry.retry.FailedSubscribedTask;
import org.apache.dubbo.registry.retry.FailedUnregisteredTask;
import org.apache.dubbo.registry.retry.FailedUnsubscribedTask;
import org.apache.dubbo.registry.support.AbstractRegistry;
import org.apache.dubbo.registry.support.SkipFailbackWrapperException;

public abstract class FailbackRegistry
extends AbstractRegistry {
    private final ConcurrentMap<URL, FailedRegisteredTask> failedRegistered = new ConcurrentHashMap<URL, FailedRegisteredTask>();
    private final ConcurrentMap<URL, FailedUnregisteredTask> failedUnregistered = new ConcurrentHashMap<URL, FailedUnregisteredTask>();
    private final ConcurrentMap<Holder, FailedSubscribedTask> failedSubscribed = new ConcurrentHashMap<Holder, FailedSubscribedTask>();
    private final ConcurrentMap<Holder, FailedUnsubscribedTask> failedUnsubscribed = new ConcurrentHashMap<Holder, FailedUnsubscribedTask>();
    private final ConcurrentMap<Holder, FailedNotifiedTask> failedNotified = new ConcurrentHashMap<Holder, FailedNotifiedTask>();
    private final int retryPeriod;
    private final HashedWheelTimer retryTimer;

    public FailbackRegistry(URL url) {
        super(url);
        this.retryPeriod = url.getParameter("retry.period", 5000);
        this.retryTimer = new HashedWheelTimer(new NamedThreadFactory("DubboRegistryRetryTimer", true), this.retryPeriod, TimeUnit.MILLISECONDS, 128);
    }

    public void removeFailedRegisteredTask(URL url) {
        this.failedRegistered.remove(url);
    }

    public void removeFailedUnregisteredTask(URL url) {
        this.failedUnregistered.remove(url);
    }

    public void removeFailedSubscribedTask(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        this.failedSubscribed.remove(h);
    }

    public void removeFailedUnsubscribedTask(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        this.failedUnsubscribed.remove(h);
    }

    public void removeFailedNotifiedTask(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        this.failedNotified.remove(h);
    }

    private void addFailedRegistered(URL url) {
        FailedRegisteredTask oldOne = (FailedRegisteredTask)this.failedRegistered.get(url);
        if (oldOne != null) {
            return;
        }
        FailedRegisteredTask newTask = new FailedRegisteredTask(url, this);
        oldOne = this.failedRegistered.putIfAbsent(url, newTask);
        if (oldOne == null) {
            this.retryTimer.newTimeout(newTask, this.retryPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void removeFailedRegistered(URL url) {
        FailedRegisteredTask f = (FailedRegisteredTask)this.failedRegistered.remove(url);
        if (f != null) {
            f.cancel();
        }
    }

    private void addFailedUnregistered(URL url) {
        FailedUnregisteredTask oldOne = (FailedUnregisteredTask)this.failedUnregistered.get(url);
        if (oldOne != null) {
            return;
        }
        FailedUnregisteredTask newTask = new FailedUnregisteredTask(url, this);
        oldOne = this.failedUnregistered.putIfAbsent(url, newTask);
        if (oldOne == null) {
            this.retryTimer.newTimeout(newTask, this.retryPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void removeFailedUnregistered(URL url) {
        FailedUnregisteredTask f = (FailedUnregisteredTask)this.failedUnregistered.remove(url);
        if (f != null) {
            f.cancel();
        }
    }

    protected void addFailedSubscribed(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        FailedSubscribedTask oldOne = (FailedSubscribedTask)this.failedSubscribed.get(h);
        if (oldOne != null) {
            return;
        }
        FailedSubscribedTask newTask = new FailedSubscribedTask(url, this, listener);
        oldOne = this.failedSubscribed.putIfAbsent(h, newTask);
        if (oldOne == null) {
            this.retryTimer.newTimeout(newTask, this.retryPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void removeFailedSubscribed(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        FailedSubscribedTask f = (FailedSubscribedTask)this.failedSubscribed.remove(h);
        if (f != null) {
            f.cancel();
        }
        this.removeFailedUnsubscribed(url, listener);
        this.removeFailedNotified(url, listener);
    }

    private void addFailedUnsubscribed(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        FailedUnsubscribedTask oldOne = (FailedUnsubscribedTask)this.failedUnsubscribed.get(h);
        if (oldOne != null) {
            return;
        }
        FailedUnsubscribedTask newTask = new FailedUnsubscribedTask(url, this, listener);
        oldOne = this.failedUnsubscribed.putIfAbsent(h, newTask);
        if (oldOne == null) {
            this.retryTimer.newTimeout(newTask, this.retryPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void removeFailedUnsubscribed(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        FailedUnsubscribedTask f = (FailedUnsubscribedTask)this.failedUnsubscribed.remove(h);
        if (f != null) {
            f.cancel();
        }
    }

    private void addFailedNotified(URL url, NotifyListener listener, List<URL> urls) {
        Holder h = new Holder(url, listener);
        FailedNotifiedTask newTask = new FailedNotifiedTask(url, listener);
        FailedNotifiedTask f = this.failedNotified.putIfAbsent(h, newTask);
        if (f == null) {
            newTask.addUrlToRetry(urls);
            this.retryTimer.newTimeout(newTask, this.retryPeriod, TimeUnit.MILLISECONDS);
        } else {
            newTask.addUrlToRetry(urls);
        }
    }

    private void removeFailedNotified(URL url, NotifyListener listener) {
        Holder h = new Holder(url, listener);
        FailedNotifiedTask f = (FailedNotifiedTask)this.failedNotified.remove(h);
        if (f != null) {
            f.cancel();
        }
    }

    ConcurrentMap<URL, FailedRegisteredTask> getFailedRegistered() {
        return this.failedRegistered;
    }

    ConcurrentMap<URL, FailedUnregisteredTask> getFailedUnregistered() {
        return this.failedUnregistered;
    }

    ConcurrentMap<Holder, FailedSubscribedTask> getFailedSubscribed() {
        return this.failedSubscribed;
    }

    ConcurrentMap<Holder, FailedUnsubscribedTask> getFailedUnsubscribed() {
        return this.failedUnsubscribed;
    }

    ConcurrentMap<Holder, FailedNotifiedTask> getFailedNotified() {
        return this.failedNotified;
    }

    @Override
    public void register(URL url) {
        if (!this.acceptable(url)) {
            this.logger.info("URL " + url + " will not be registered to Registry. Registry " + url + " does not accept service of this protocol type.");
            return;
        }
        super.register(url);
        this.removeFailedRegistered(url);
        this.removeFailedUnregistered(url);
        try {
            this.doRegister(url);
        }
        catch (Exception e) {
            Throwable t = e;
            boolean check = this.getUrl().getParameter("check", true) && url.getParameter("check", true) && !"consumer".equals(url.getProtocol());
            boolean skipFailback = t instanceof SkipFailbackWrapperException;
            if (check || skipFailback) {
                if (skipFailback) {
                    t = t.getCause();
                }
                throw new IllegalStateException("Failed to register " + url + " to registry " + this.getUrl().getAddress() + ", cause: " + t.getMessage(), t);
            }
            this.logger.error("Failed to register " + url + ", waiting for retry, cause: " + t.getMessage(), t);
            this.addFailedRegistered(url);
        }
    }

    @Override
    public void reExportRegister(URL url) {
        block3: {
            if (!this.acceptable(url)) {
                this.logger.info("URL " + url + " will not be registered to Registry. Registry " + url + " does not accept service of this protocol type.");
                return;
            }
            super.register(url);
            this.removeFailedRegistered(url);
            this.removeFailedUnregistered(url);
            try {
                this.doRegister(url);
            }
            catch (Exception e) {
                if (e instanceof SkipFailbackWrapperException) break block3;
                throw new IllegalStateException("Failed to register (re-export) " + url + " to registry " + this.getUrl().getAddress() + ", cause: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void unregister(URL url) {
        super.unregister(url);
        this.removeFailedRegistered(url);
        this.removeFailedUnregistered(url);
        try {
            this.doUnregister(url);
        }
        catch (Exception e) {
            Throwable t = e;
            boolean check = this.getUrl().getParameter("check", true) && url.getParameter("check", true) && !"consumer".equals(url.getProtocol());
            boolean skipFailback = t instanceof SkipFailbackWrapperException;
            if (check || skipFailback) {
                if (skipFailback) {
                    t = t.getCause();
                }
                throw new IllegalStateException("Failed to unregister " + url + " to registry " + this.getUrl().getAddress() + ", cause: " + t.getMessage(), t);
            }
            this.logger.error("Failed to unregister " + url + ", waiting for retry, cause: " + t.getMessage(), t);
            this.addFailedUnregistered(url);
        }
    }

    @Override
    public void reExportUnregister(URL url) {
        block2: {
            super.unregister(url);
            this.removeFailedRegistered(url);
            this.removeFailedUnregistered(url);
            try {
                this.doUnregister(url);
            }
            catch (Exception e) {
                if (e instanceof SkipFailbackWrapperException) break block2;
                throw new IllegalStateException("Failed to unregister(re-export) " + url + " to registry " + this.getUrl().getAddress() + ", cause: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        super.subscribe(url, listener);
        this.removeFailedSubscribed(url, listener);
        try {
            this.doSubscribe(url, listener);
        }
        catch (Exception e) {
            Throwable t = e;
            List<URL> urls = this.getCacheUrls(url);
            if (CollectionUtils.isNotEmpty(urls)) {
                this.notify(url, listener, urls);
                this.logger.error("Failed to subscribe " + url + ", Using cached list: " + urls + " from cache file: " + this.getUrl().getParameter("file", System.getProperty("user.home") + "/dubbo-registry-" + url.getHost() + ".cache") + ", cause: " + t.getMessage(), t);
            } else {
                boolean check = this.getUrl().getParameter("check", true) && url.getParameter("check", true);
                boolean skipFailback = t instanceof SkipFailbackWrapperException;
                if (check || skipFailback) {
                    if (skipFailback) {
                        t = t.getCause();
                    }
                    throw new IllegalStateException("Failed to subscribe " + url + ", cause: " + t.getMessage(), t);
                }
                this.logger.error("Failed to subscribe " + url + ", waiting for retry, cause: " + t.getMessage(), t);
            }
            this.addFailedSubscribed(url, listener);
        }
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        super.unsubscribe(url, listener);
        this.removeFailedSubscribed(url, listener);
        try {
            this.doUnsubscribe(url, listener);
        }
        catch (Exception e) {
            Throwable t = e;
            boolean check = this.getUrl().getParameter("check", true) && url.getParameter("check", true);
            boolean skipFailback = t instanceof SkipFailbackWrapperException;
            if (check || skipFailback) {
                if (skipFailback) {
                    t = t.getCause();
                }
                throw new IllegalStateException("Failed to unsubscribe " + url + " to registry " + this.getUrl().getAddress() + ", cause: " + t.getMessage(), t);
            }
            this.logger.error("Failed to unsubscribe " + url + ", waiting for retry, cause: " + t.getMessage(), t);
            this.addFailedUnsubscribed(url, listener);
        }
    }

    @Override
    protected void notify(URL url, NotifyListener listener, List<URL> urls) {
        if (url == null) {
            throw new IllegalArgumentException("notify url == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notify listener == null");
        }
        try {
            this.doNotify(url, listener, urls);
        }
        catch (Exception t) {
            this.addFailedNotified(url, listener, urls);
            this.logger.error("Failed to notify for subscribe " + url + ", waiting for retry, cause: " + t.getMessage(), t);
        }
    }

    protected void doNotify(URL url, NotifyListener listener, List<URL> urls) {
        super.notify(url, listener, urls);
    }

    @Override
    protected void recover() throws Exception {
        HashMap<URL, Set<NotifyListener>> recoverSubscribed;
        HashSet<URL> recoverRegistered = new HashSet<URL>(this.getRegistered());
        if (!recoverRegistered.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Recover register url " + recoverRegistered);
            }
            for (URL url : recoverRegistered) {
                this.addFailedRegistered(url);
            }
        }
        if (!(recoverSubscribed = new HashMap<URL, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Recover subscribe url " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.addFailedSubscribed(url, listener);
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.retryTimer.stop();
    }

    public abstract void doRegister(URL var1);

    public abstract void doUnregister(URL var1);

    public abstract void doSubscribe(URL var1, NotifyListener var2);

    public abstract void doUnsubscribe(URL var1, NotifyListener var2);

    static class Holder {
        private final URL url;
        private final NotifyListener notifyListener;

        Holder(URL url, NotifyListener notifyListener) {
            if (url == null || notifyListener == null) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.notifyListener = notifyListener;
        }

        public int hashCode() {
            return this.url.hashCode() + this.notifyListener.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Holder) {
                Holder h = (Holder)obj;
                return this.url.equals(h.url) && this.notifyListener.equals(h.notifyListener);
            }
            return false;
        }
    }
}

