/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.service.GenericService;

public class RpcUtils {
    private static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);

    public static Class<?> getReturnType(Invocation invocation) {
        try {
            String service;
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && invocation.getInvoker().getInterface() != GenericService.class && !invocation.getMethodName().startsWith("$") && StringUtils.isNotEmpty(service = invocation.getInvoker().getUrl().getServiceInterface())) {
                Method method = RpcUtils.getMethodByService(invocation, service);
                return method.getReturnType();
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return null;
    }

    public static Type[] getReturnTypes(Invocation invocation) {
        try {
            String service;
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && invocation.getInvoker().getInterface() != GenericService.class && !invocation.getMethodName().startsWith("$") && StringUtils.isNotEmpty(service = invocation.getInvoker().getUrl().getServiceInterface())) {
                Method method = RpcUtils.getMethodByService(invocation, service);
                return ReflectUtils.getReturnTypes(method);
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return null;
    }

    public static Long getInvocationId(Invocation inv) {
        String id = inv.getAttachment("id");
        return id == null ? null : new Long(id);
    }

    public static void attachInvocationIdIfAsync(URL url, Invocation inv) {
        if (RpcUtils.isAttachInvocationId(url, inv) && RpcUtils.getInvocationId(inv) == null && inv instanceof RpcInvocation) {
            ((RpcInvocation)inv).setAttachment("id", String.valueOf(INVOKE_ID.getAndIncrement()));
        }
    }

    private static boolean isAttachInvocationId(URL url, Invocation invocation) {
        String value = url.getMethodParameter(invocation.getMethodName(), "invocationid.autoattach");
        if (value == null) {
            return RpcUtils.isAsync(url, invocation);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public static String getMethodName(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 0 && invocation.getArguments()[0] instanceof String) {
            return (String)invocation.getArguments()[0];
        }
        return invocation.getMethodName();
    }

    public static Object[] getArguments(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 2 && invocation.getArguments()[2] instanceof Object[]) {
            return (Object[])invocation.getArguments()[2];
        }
        return invocation.getArguments();
    }

    public static Class<?>[] getParameterTypes(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 1 && invocation.getArguments()[1] instanceof String[]) {
            String[] types = (String[])invocation.getArguments()[1];
            if (types == null) {
                return new Class[0];
            }
            Class[] parameterTypes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = ReflectUtils.forName(types[0]);
            }
            return parameterTypes;
        }
        return invocation.getParameterTypes();
    }

    public static boolean isAsync(URL url, Invocation inv) {
        boolean isAsync = Boolean.TRUE.toString().equals(inv.getAttachment("async")) ? true : url.getMethodParameter(RpcUtils.getMethodName(inv), "async", false);
        return isAsync;
    }

    public static boolean isReturnTypeFuture(Invocation inv) {
        Class<?> clazz = inv instanceof RpcInvocation ? ((RpcInvocation)inv).getReturnType() : RpcUtils.getReturnType(inv);
        return clazz != null && CompletableFuture.class.isAssignableFrom(clazz) || RpcUtils.isGenericAsync(inv);
    }

    public static boolean isGenericAsync(Invocation inv) {
        return "$invokeAsync".equals(inv.getMethodName());
    }

    public static boolean isGenericCall(String path, String method) {
        return "$invoke".equals(method) || "$invokeAsync".equals(method);
    }

    public static boolean isEcho(String path, String method) {
        return "$echo".equals(method);
    }

    public static InvokeMode getInvokeMode(URL url, Invocation inv) {
        if (RpcUtils.isReturnTypeFuture(inv)) {
            return InvokeMode.FUTURE;
        }
        if (RpcUtils.isAsync(url, inv)) {
            return InvokeMode.ASYNC;
        }
        return InvokeMode.SYNC;
    }

    public static boolean isOneway(URL url, Invocation inv) {
        boolean isOneway = Boolean.FALSE.toString().equals(inv.getAttachment("return")) ? true : !url.getMethodParameter(RpcUtils.getMethodName(inv), "return", true);
        return isOneway;
    }

    private static Method getMethodByService(Invocation invocation, String service) throws NoSuchMethodException {
        Class<?> invokerInterface = invocation.getInvoker().getInterface();
        Class<?> cls = invokerInterface != null ? ReflectUtils.forName(invokerInterface.getClassLoader(), service) : ReflectUtils.forName(service);
        Method method = cls.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        return method;
    }

    public static long getTimeout(Invocation invocation, long defaultTimeout) {
        long timeout = defaultTimeout;
        Object genericTimeout = invocation.getObjectAttachment("_TO");
        if (genericTimeout != null) {
            timeout = RpcUtils.convertToNumber(genericTimeout, defaultTimeout);
        }
        return timeout;
    }

    public static long getTimeout(URL url, String methodName, RpcContext context, long defaultTimeout) {
        long timeout = defaultTimeout;
        Object genericTimeout = context.getObjectAttachment("timeout");
        if (genericTimeout != null) {
            timeout = RpcUtils.convertToNumber(genericTimeout, defaultTimeout);
        } else if (url != null) {
            timeout = url.getMethodPositiveParameter(methodName, "timeout", defaultTimeout);
        }
        return timeout;
    }

    private static long convertToNumber(Object obj, long defaultTimeout) {
        long timeout = 0L;
        try {
            timeout = obj instanceof String ? Long.parseLong((String)obj) : (obj instanceof Number ? ((Number)obj).longValue() : Long.parseLong(obj.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }
}

