/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.avro;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.dubbo.common.serialize.ObjectInput;

public class AvroObjectInput
implements ObjectInput {
    private static DecoderFactory decoderFactory = DecoderFactory.get();
    private BinaryDecoder decoder;

    public AvroObjectInput(InputStream in) {
        this.decoder = decoderFactory.binaryDecoder(in, null);
    }

    @Override
    public boolean readBool() throws IOException {
        return this.decoder.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        byte[] bytes = new byte[1];
        this.decoder.readFixed(bytes);
        return bytes[0];
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.decoder.readInt();
    }

    @Override
    public int readInt() throws IOException {
        return this.decoder.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.decoder.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.decoder.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.decoder.readDouble();
    }

    @Override
    public String readUTF() throws IOException {
        Utf8 result = new Utf8();
        result = this.decoder.readString(result);
        return result.toString();
    }

    @Override
    public byte[] readBytes() throws IOException {
        String resultStr = this.decoder.readString();
        return resultStr.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        ReflectDatumReader reader = new ReflectDatumReader(Object.class);
        return reader.read(null, (Decoder)this.decoder);
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        if (cls == Map.class) {
            cls = HashMap.class;
        }
        ReflectDatumReader reader = new ReflectDatumReader(cls);
        return (T)reader.read(null, (Decoder)this.decoder);
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        ReflectDatumReader reader = new ReflectDatumReader(cls);
        return (T)reader.read(null, (Decoder)this.decoder);
    }
}

