/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class ThreadlessExecutor
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadlessExecutor.class.getName());
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private ExecutorService sharedExecutor;
    private CompletableFuture<?> waitingFuture;
    private boolean finished = false;
    private volatile boolean waiting = true;
    private final Object lock = new Object();

    public ThreadlessExecutor(ExecutorService sharedExecutor) {
        this.sharedExecutor = sharedExecutor;
    }

    public CompletableFuture<?> getWaitingFuture() {
        return this.waitingFuture;
    }

    public void setWaitingFuture(CompletableFuture<?> waitingFuture) {
        this.waitingFuture = waitingFuture;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndDrain() throws InterruptedException {
        if (this.finished) {
            return;
        }
        Runnable runnable = this.queue.take();
        Object object = this.lock;
        synchronized (object) {
            this.waiting = false;
            runnable.run();
        }
        runnable = (Runnable)this.queue.poll();
        while (runnable != null) {
            runnable.run();
            runnable = (Runnable)this.queue.poll();
        }
        this.finished = true;
    }

    public long waitAndDrain(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        runnable = new RunnableWrapper(runnable);
        Object object = this.lock;
        synchronized (object) {
            if (!this.waiting) {
                this.sharedExecutor.execute(runnable);
            } else {
                this.queue.add(runnable);
            }
        }
    }

    public void notifyReturn(Throwable t) {
        this.execute(() -> this.waitingFuture.completeExceptionally(t));
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.notifyReturn(new IllegalStateException("Consumer is shutting down and this call is going to be stopped without receiving any result, usually this is called by a slow provider instance or bad service implementation."));
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    private static class RunnableWrapper
    implements Runnable {
        private Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                logger.info(t);
            }
        }
    }
}

