/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter
implements MetadataServiceExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MetadataService metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;

    public ConfigurableMetadataServiceExporter(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public ConfigurableMetadataServiceExporter export() {
        if (!this.isExported()) {
            ServiceConfig<MetadataService> serviceConfig = new ServiceConfig<MetadataService>();
            serviceConfig.setApplication(this.getApplicationConfig());
            serviceConfig.setRegistries(this.getRegistries());
            serviceConfig.setProtocol(this.generateMetadataProtocol());
            serviceConfig.setInterface(MetadataService.class);
            serviceConfig.setRef(this.metadataService);
            serviceConfig.setGroup(this.getApplicationConfig().getName());
            serviceConfig.setVersion(this.metadataService.version());
            serviceConfig.setMethods(this.generateMethodConfig());
            serviceConfig.export();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + serviceConfig.getExportedUrls());
            }
            this.serviceConfig = serviceConfig;
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenServiceDiscoveryMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(1);
        argumentConfig.setCallback(true);
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }

    @Override
    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
        }
        return this;
    }

    @Override
    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }

    @Override
    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported();
    }

    private ApplicationConfig getApplicationConfig() {
        return ApplicationModel.getConfigManager().getApplication().get();
    }

    private List<RegistryConfig> getRegistries() {
        return new ArrayList<RegistryConfig>(ApplicationModel.getConfigManager().getRegistries());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig defaultProtocol = new ProtocolConfig();
        Integer port = this.getApplicationConfig().getMetadataServicePort();
        if (port == null || port < -1) {
            List<ProtocolConfig> defaultProtocols;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Metadata Service Port hasn't been set. Use default protocol defined in protocols.");
            }
            if (!(defaultProtocols = ApplicationModel.getConfigManager().getDefaultProtocols()).isEmpty()) return defaultProtocols.get(0);
            defaultProtocol.setName("dubbo");
            defaultProtocol.setPort(-1);
            return defaultProtocol;
        } else {
            defaultProtocol.setName("dubbo");
            defaultProtocol.setPort(port);
        }
        return defaultProtocol;
    }
}

