/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;

public class MetadataReportInstance {
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static final Map<String, MetadataReport> metadataReports = new HashMap<String, MetadataReport>();

    public static void init(MetadataReportConfig config) {
        if (init.get()) {
            return;
        }
        MetadataReportFactory metadataReportFactory = ExtensionLoader.getExtensionLoader(MetadataReportFactory.class).getAdaptiveExtension();
        URL url = config.toUrl();
        if ("metadata".equals(url.getProtocol())) {
            String protocol = url.getParameter("metadata", "dubbo");
            url = URLBuilder.from(url).setProtocol(protocol).removeParameter("metadata").build();
        }
        String relatedRegistryId = config.getRegistry() == null ? "default" : config.getRegistry();
        metadataReports.put(relatedRegistryId, metadataReportFactory.getMetadataReport(url));
        init.set(true);
    }

    public static Map<String, MetadataReport> getMetadataReports(boolean checked) {
        if (checked) {
            MetadataReportInstance.checkInit();
        }
        return metadataReports;
    }

    public static MetadataReport getMetadataReport(String registryKey) {
        MetadataReportInstance.checkInit();
        MetadataReport metadataReport = metadataReports.get(registryKey);
        if (metadataReport == null) {
            metadataReport = metadataReports.values().iterator().next();
        }
        return metadataReport;
    }

    private static void checkInit() {
        if (!init.get()) {
            throw new IllegalStateException("the metadata report was not inited.");
        }
    }
}

