/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.zookeeper;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;

public class ZookeeperMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperMetadataReport.class);
    private final String root;
    final ZookeeperClient zkClient;
    private Gson gson = new Gson();
    private Map<String, ChildListener> listenerMap = new ConcurrentHashMap<String, ChildListener>();

    public ZookeeperMetadataReport(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.zkClient.create(this.getNodePath(metadataIdentifier), URL.encode(url.toFullString()), false);
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.zkClient.delete(this.getNodePath(metadataIdentifier));
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.zkClient.getContent(this.getNodePath(metadataIdentifier));
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode(content)));
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urls) {
        this.zkClient.create(this.getNodePath(subscriberMetadataIdentifier), urls, false);
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath(subscriberMetadataIdentifier));
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath(metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        this.zkClient.create(this.getNodePath(metadataIdentifier), v, false);
    }

    String getNodePath(BaseMetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    @Override
    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String path = this.getNodePath(identifier);
        if (StringUtils.isBlank(this.zkClient.getContent(path))) {
            this.zkClient.create(path, this.gson.toJson((Object)metadataInfo), false);
        }
    }

    @Override
    public void registerServiceAppMapping(String serviceKey, String application, URL url) {
        String path = this.toRootDir() + serviceKey + "/" + application;
        if (StringUtils.isBlank(this.zkClient.getContent(path))) {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("timestamp", String.valueOf(System.currentTimeMillis()));
            this.zkClient.create(path, this.gson.toJson(value), false);
        }
    }

    @Override
    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        String content = this.zkClient.getContent(this.getNodePath(identifier));
        return (MetadataInfo)this.gson.fromJson(content, MetadataInfo.class);
    }

    @Override
    public Set<String> getServiceAppMapping(final String serviceKey, final MappingListener listener, URL url) {
        HashSet<String> appNameSet = new HashSet<String>();
        String path = this.toRootDir() + serviceKey;
        appNameSet.addAll(this.zkClient.getChildren(path));
        if (null == this.listenerMap.get(path)) {
            ChildListener zkListener = new ChildListener(){

                @Override
                public void childChanged(String path, List<String> children) {
                    MappingChangedEvent event = new MappingChangedEvent();
                    event.setServiceKey(serviceKey);
                    event.setApps((Set<String>)(null != children ? new HashSet<String>(children) : null));
                    listener.onEvent(event);
                }
            };
            this.zkClient.addChildListener(path, zkListener);
            this.listenerMap.put(path, zkListener);
        }
        return appNameSet;
    }
}

