/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

@Cmd(name="publishMetadata", summary="update service metadata and service instance", example={"publishMetadata", "publishMetadata 5"})
public class PublishMetadata
implements BaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(PublishMetadata.class);
    private final ExecutorRepository executorRepository = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    private ScheduledFuture future;

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        logger.info("received publishMetadata command.");
        if (ArrayUtils.isEmpty(args)) {
            ServiceInstanceMetadataUtils.refreshMetadataAndInstance();
            return "publish metadata succeeded.";
        }
        try {
            int delay = Integer.parseInt(args[0]);
            if (this.future == null || this.future.isDone() || this.future.isCancelled()) {
                this.future = this.executorRepository.nextScheduledExecutor().scheduleWithFixedDelay(ServiceInstanceMetadataUtils::refreshMetadataAndInstance, 0L, delay, TimeUnit.MILLISECONDS);
            }
        }
        catch (NumberFormatException e) {
            logger.error("Wrong delay param", e);
            return "publishMetadata failed! Wrong delay param!";
        }
        return "publish task submitted, will publish in " + args[0] + " seconds.";
    }
}

